package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * --  6.3.2.4 加密消息内容
 * --  recipients 消息接受者
 * --  cipherText 被加密的消息密文和算法参数
 * EncryptedData ::= SEQUENCE{
 * recipients  SequenceOfRecipientInfo,
 * cipherText  SymmetricCipherText
 * }
 */
public class EncryptedData extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(EncryptedData.class);
    private SequenceOfRecipientInfo recipients;
    private SymmetricCipherText cipherText;

    public EncryptedData() {
        super(false, false);
    }

    public static EncryptedData getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "EncryptedData start data ", data);
        EncryptedData encryptedData = new EncryptedData();
        SequenceOfRecipientInfo recipients = SequenceOfRecipientInfo.getInstance(data);
        encryptedData.setRecipients(recipients);
        data = recipients.getGoal();
        ByteArrayUtils.printHexBinary(logger, "EncryptedData recipients data ", recipients.getEncode());
        SymmetricCipherText cipherText = SymmetricCipherText.getInstance(data);
        encryptedData.setCipherText(cipherText);
        encryptedData.setGoal(cipherText.getGoal());
        ByteArrayUtils.printHexBinary(logger, "EncryptedData cipherText data ", cipherText.getEncode());
        ByteArrayUtils.printHexBinary(logger, "EncryptedData lave data ", encryptedData.getGoal());
        return encryptedData;
    }


    public void setRecipients(SequenceOfRecipientInfo recipients) {
        this.recipients = recipients;
    }

    public void setCipherText(SymmetricCipherText cipherText) {
        this.cipherText = cipherText;
    }

    public SequenceOfRecipientInfo getRecipients() {
        return recipients;
    }

    public SymmetricCipherText getCipherText() {
        return cipherText;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(recipients);
        vector.add(cipherText);
        return vector;
    }
}
