package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;

/***
 * -- 6.2.2.3 签名者信息
 * IssuerId :: = CHOICE {
 * self NULL, -- 自签名 无额外数据
 * CertificateDigest CertificateDigest, -- 用指定的摘要算法对证书计算Hash 得到的标识
 * ...
 * }
 */
public class IssuerId extends Choice {
    private static Logger logger = LoggerFactory.getLogger(IssuerId.class);
    private Null self;
    private CertificateDigest certificateDigest;

    public static IssuerId getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "IssuerId start data ", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        System.out.println(choice);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        IssuerId issuerId = new IssuerId();
        if (choice.intValue() - 0x80 == 0) {
            logger.debug("IssuerId choice self");
            issuerId.setSelf(new Null());
            issuerId.setGoal(data);
        } else if (choice.intValue() - 0x80 == 1) {
            logger.debug("IssuerId choice certificateDigest");
            CertificateDigest certificateDigest = CertificateDigest.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "IssuerId certificateDigest data ", certificateDigest.getEncode());
            issuerId.setCertificateDigest(certificateDigest);
            issuerId.setGoal(certificateDigest.getGoal());
        } else {
            logger.error("IssuerId choice is error " + choice.intValue());
            throw new Exception("不支持的类型");
        }
        ByteArrayUtils.printHexBinary(logger, "IssuerId certificateDigest d ", issuerId.getGoal());
        return issuerId;
    }

    public Null getSelf() {
        return self;
    }

    public void setSelf(Null self) {
        this.self = self;
    }

    public CertificateDigest getCertificateDigest() {
        return certificateDigest;
    }

    public void setCertificateDigest(CertificateDigest certificateDigest) {
        this.addIndex(1);
        this.certificateDigest = certificateDigest;
    }

    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        vector.add(self);
        vector.add(certificateDigest);
        return vector;
    }
//
//    public IssuerId(byte[] hash) throws IOException {
//        writeCertificateDigest(hash);
//    }
//
//    private void writeSelfSign() throws IOException {
//        this.addIndexes(Arrays.asList(7));
//    }

//    private void writeCertificateDigest(byte[] hash) throws IOException {
//        this.addIndexes(Arrays.asList(7, 0));
//        CertificateDigest certificateDigest = new CertificateDigest();
//        HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
//        certificateDigest.setHashAlgorithm(hashAlgorithm);
//        certificateDigest.setHashedId8(new HashedId8(hash));
//        this.write(certificateDigest.getEncode());
//    }
}
