package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Uint64;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;

public class ItsAid extends Uint64 {

    //  安全功能预留 Safety function reservation
    public static ItsAid SAFETY_FUNCTION_RESERVATION;
    //  通用注册证书申请 Application for general registration certificate
    public static ItsAid REGISTRATION_CERTIFICATE_REQUEST;
    //  通用注册证书应答 General certificate of registration response
    public static ItsAid REGISTRATION_CERTIFICATE_RESPONSE;
    //  通用非注册证书申请 Application for general non-registration certificate
    public static ItsAid NON_REGISTRATION_CERTIFICATE_REQUEST;
    //  通用非注册证书应答 General unregistered certificate response
    public static ItsAid NON_REGISTRATION_CERTIFICATE_RESPONSE;
    //  证书吊销列表 crl
    public static ItsAid CRL;
    //  密钥协商 key agreement
    public static ItsAid KEY_AGREEMENT;

    //自定义扩展

    // 红绿灯应用 Traffic light application
    public static ItsAid TRAFFIC_LIGHT_APPLICATION;

    private static final Logger logger = LoggerFactory.getLogger(ItsAid.class.getName());

    public static ItsAid getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "ItsAid  start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 8);
        ItsAid itsAid = new ItsAid(integer.longValue());
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        itsAid.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "ItsAid  lave data", itsAid.getGoal());
        return itsAid;
    }

    static {
        try {
            SAFETY_FUNCTION_RESERVATION = new ItsAid(40960); // 0xa000
            REGISTRATION_CERTIFICATE_REQUEST = new ItsAid(40961); // 0xa001
            REGISTRATION_CERTIFICATE_RESPONSE = new ItsAid(40962); // 0xa002
            NON_REGISTRATION_CERTIFICATE_REQUEST = new ItsAid(40963); // 0xa003
            NON_REGISTRATION_CERTIFICATE_RESPONSE = new ItsAid(40964); // 0xa004
            CRL = new ItsAid(41216); // 0xa100
            KEY_AGREEMENT = new ItsAid(41472); // 0xa200

            //  自定义扩展
            TRAFFIC_LIGHT_APPLICATION = new ItsAid(45057); // Oxb001
        } catch (IOException e) {
            logger.error("generate its aid error", e);
        }
    }

    public ItsAid(long l) throws IOException {
        super(l);
    }

}
