package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint64;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Vector;

/***
 *
 * ItsAidSsp ::= SEQUENCE {
 *     itsAid ItsAid,
 *     serviceSpecificPermissions OCTET STRING(SIZE(1..32))
 * }
 *
 */
public class ItsAidSsp extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(ItsAidSsp.class);
    private ItsAid itsAid;
    private OctetString serviceSpecificPermissions;

    public ItsAidSsp() {
        super(false, false);
    }

    public static ItsAidSsp getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp start data", data);
        ItsAid itsAid = ItsAid.getInstance(data);
        data = itsAid.getGoal();
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp itsAid data", itsAid.getEncode());
        OctetString octetString = OctetString.getInstance(data);
        OctetString serviceSpecificPermissions = new OctetString();
        serviceSpecificPermissions.setString(octetString.getString());
        data = octetString.getGoal();
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp serviceSpecificPermissions data", serviceSpecificPermissions.getEncode());
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setServiceSpecificPermissions(serviceSpecificPermissions);
        itsAidSsp.setItsAid(itsAid);
        itsAidSsp.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp lave data", itsAidSsp.getGoal());
        return itsAidSsp;
    }

    public void setItsAid(ItsAid itsAid) {
        this.itsAid = itsAid;
    }

    public void setServiceSpecificPermissions(OctetString serviceSpecificPermissions) {
        this.serviceSpecificPermissions = serviceSpecificPermissions;
    }

    public void setServiceSpecificPermissions(byte[] serviceSpecificPermissions) throws IOException {
        this.serviceSpecificPermissions = new OctetString();
        this.serviceSpecificPermissions.setString(serviceSpecificPermissions);
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(itsAid);
        vector.add(serviceSpecificPermissions);
        return vector;
    }
}
