package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.SequenceOf;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

/***
 *
 * -- 6.2.1.13 多边形区域
 *
 * PolygonalRegion ::= SEQUENCE SIZE (3..MAX) OF TwoDLocation
 *
 */
public class PolygonalRegion extends SequenceOf {

    private static Logger logger = LoggerFactory.getLogger(PolygonalRegion.class);

    public void addTwoDLocation(TwoDLocation twoDLocation) {
        super.addOERObject(twoDLocation);
    }

    public static PolygonalRegion getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "PolygonalRegion start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        PolygonalRegion polygonalRegion = new PolygonalRegion();
        for (int i = 0; i < length.intValue(); i++) {
            TwoDLocation instance = TwoDLocation.getInstance(goal);
            goal = instance.getGoal();
            polygonalRegion.addTwoDLocation(instance);
            ByteArrayUtils.printHexBinary(logger, "PolygonalRegion  at index" + i + "TwoDLocation data ", instance.getEncode());
        }
        polygonalRegion.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "PolygonalRegion lave data ", goal);
        return polygonalRegion;
    }

}
