package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * -- 6.2.10 签名者信息
 * -- self: 自签名，无额外数据；
 * -- certificateDigest: 用指定摘要算法对证书计算HASH，得到的标识。。
 * SignerInfo ::= CHOICE {
 * self                NULL,
 * certificate         SequenceOfCertificate,
 * certificateDigest   CertificateDigest,
 * ...
 * };
 */
public class SignerInfo extends Choice {
    private static Logger logger = LoggerFactory.getLogger(SignerInfo.class);
    private Null self;
    private SequenceOfCertificate certificate;
    private CertificateDigest certificateDigest;

    public SignerInfo(Null self) {
        this.self = self;
        this.certificate = null;
        this.certificateDigest = null;
    }

    public SignerInfo(SequenceOfCertificate certificate) {
        this.addIndex(1);
        this.self = null;
        this.certificate = certificate;
        this.certificateDigest = null;
    }

    public SignerInfo(CertificateDigest certificateDigest) {
        this.addIndex(2);
        this.self = null;
        this.certificate = null;
        this.certificateDigest = certificateDigest;
    }

    public static SignerInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SignerInfo start data ", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        System.out.println(choice);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        SignerInfo signerInfo;
        if (choice.intValue() - 0x80 == 0) {
            logger.debug("SignerInfo choice self");
            signerInfo = new SignerInfo(new Null());
            signerInfo.setGoal(data);
        } else if (choice.intValue() - 0x80 == 1) {
            logger.debug("SignerInfo choice certificate");
            SequenceOfCertificate certificate = SequenceOfCertificate.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "SignerInfo SequenceOfCertificate data ", certificate.getEncode());
            signerInfo = new SignerInfo(certificate);
            signerInfo.setGoal(certificate.getGoal());
        } else if (choice.intValue() - 0x80 == 2) {
            logger.debug("SignerInfo choice certificateDigest");
            CertificateDigest certificateDigest = CertificateDigest.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "SignerInfo certificateDigest data ", certificateDigest.getEncode());
            signerInfo = new SignerInfo(certificateDigest);
            signerInfo.setGoal(certificateDigest.getGoal());
        } else {
            logger.error("SignerInfo choice is error " + choice.intValue());
            throw new Exception("不支持的类型");
        }
        ByteArrayUtils.printHexBinary(logger, "SignerInfo lave data ", signerInfo.getGoal());
        return signerInfo;
    }

    public Null getSelf() {
        return self;
    }

    public SequenceOfCertificate getCertificate() {
        return certificate;
    }

    public CertificateDigest getCertificateDigest() {
        return certificateDigest;
    }


    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        if (null != this.self) {
            //0x80
            vector.add(self);
        }
        if (null != this.certificate) {
            //0x81
            vector.add(certificate);
        }

        if (null != this.certificateDigest) {
            //0x82
            vector.add(certificateDigest);
        }
        return vector;
    }
}
