package com.xdja.pki.itsca.oer.asn1.base;

import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Vector;

public abstract class OERObject {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    private ByteArrayInputStream reader;
    private int offset = 0;

    private int lengthPrefix = -1;

    protected byte[] goal;

    public byte[] getGoal() {
        return goal;
    }

    public void setGoal(byte[] goal) {
        this.goal = goal;
    }

    protected static byte[] subByteData(byte[] source, int srcPos, int len) {

        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(source);
        byteArrayInputStream.read();

        OERObject oerObject = new OERObject() {
            @Override
            public Vector getValues() throws IOException {
                return new Vector();
            }
        };
        return oerObject.subByte(source, srcPos, len);
    }

    private byte[] subByte(byte[] source, int srcPos, int len) {
        //获取的目标数组
        byte[] goal = new byte[len];
        System.arraycopy(source, srcPos, goal, 0, len);
        //剩余长度
        byte[] lave = new byte[source.length - len - srcPos];
        System.arraycopy(source, srcPos + len, lave, 0, lave.length);
        source = lave;
        return goal;
    }

    public int getLengthPrefix() {
        return lengthPrefix;
    }

    public void setLengthPrefix(int lengthPrefix) {
        this.lengthPrefix = lengthPrefix;
    }

    public void fromByteArray(byte[] obj) {
        this.reader = new ByteArrayInputStream((obj));
    }

    public int readInt() throws IOException {
        //获取长度的长度
        BigInteger len = BigIntegers.fromUnsignedByteArray(this.getEncode(), 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(this.getEncode(), 1, len.intValue() - 0x80);
        return length.intValue();
        //  return this.reader.read();
    }

    public byte readByte() throws IOException {
        if (this.reader == null) {
            this.reader = new ByteArrayInputStream(this.getEncode());
        }
        return this.readBytes(1)[0];
    }

    public byte[] readBytes(int len) throws IOException {
        if (this.reader == null) {
            this.reader = new ByteArrayInputStream(this.getEncode());
        }
        byte[] bytes = new byte[len];
        this.reader.read(bytes, offset, bytes.length);
        this.offset++;
        return bytes;
    }

    public abstract Vector getValues() throws IOException;

    private void writeLengthPrefix(ByteArrayOutputStream writer) throws IOException {
        int len = this.getLengthPrefix();

        if (len == -1) {
            return;
        }
        if (len > 127) {
            // 长度
            BigInteger lenBigInteger = BigInteger.valueOf(len);
            byte[] lenBytes = BigIntegers.asUnsignedByteArray(lenBigInteger);
//            ByteArrayUtils.printHexBinary(null, "len bytes", lenBytes);

            // 长度的长度
            int lenLength = lenBytes.length;
            BigInteger lenLengthBigInteger = BigInteger.valueOf(lenLength);
            byte[] lenLengthBytes = BigIntegers.asUnsignedByteArray(lenLengthBigInteger);
//            ByteArrayUtils.printHexBinary(null, "len len", lenLengthBytes);
            // 长度的长度 最高位设置为 1
            BitSet bitSet = BitSet.valueOf(lenLengthBytes);
//            ByteArrayUtils.printHexBinary(null, "len len bits", bitSet.toByteArray());
            bitSet.set(7);
            byte[] bitSetBytes = bitSet.toByteArray();
//            ByteArrayUtils.printHexBinary(null, "len len bits set top", bitSetBytes);

            writer.write(bitSetBytes);
            writer.write(lenBytes);
        } else {
            writer.write(len);
        }
    }

    public byte[] getEncode() throws IOException {
        Vector vector = this.getValues();
        if (vector == null) {
            return new byte[0];
        }
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        this.writeLengthPrefix(writer);
        for (Object obj : vector) {
            if (obj == null) {
                continue;
            }
            if (obj instanceof Integer) {
                writer.write((Integer) obj);
            }
            if (obj instanceof Byte) {
                writer.write((byte) obj);
            }
            if (obj instanceof byte[]) {
                writer.write((byte[]) obj);
            }
            if (obj instanceof OERObject) {
                writer.write(((OERObject) obj).getEncode());
            }
        }
        return writer.toByteArray();
    }
}
