package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.Opaque;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class OctetString extends OERObject {

    private int length = -1; // 定长的 octet string 有长度，不定长的没有长度
    private byte[] string;

    public OctetString() {
    }

    public OctetString(int length) {
        this.length = length;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getString() {
        return string;
    }

    public void setString(byte[] string) {
        this.string = string;
    }

    public static OctetString getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(null, "OctetString data", data);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        OctetString opaque = new OctetString();
        byte[] dest;
        if (length.intValue() - 0x80 > 0) {
            //len 长度
            BigInteger len = BigIntegers.fromUnsignedByteArray(data, 1, length.intValue() - 0x80);
            byte[] goal = new byte[len.intValue()];
            System.arraycopy(data, 1 + (length.intValue() - 0x80), goal, 0, goal.length);
            ByteArrayUtils.printHexBinary(null, "OctetString real data", goal);
            opaque.setString(goal);
            dest = new byte[data.length - 1 - (length.intValue() - 0x80) - len.intValue()];
            System.arraycopy(data, 1 + (length.intValue() - 0x80) + len.intValue(), dest, 0, dest.length);
            opaque.setGoal(dest);
        } else if (length.intValue() - 0x80 < 0) {
            byte[] goal = new byte[length.intValue()];
            System.out.println(length.intValue());
            System.arraycopy(data, 1, goal, 0, goal.length);
            ByteArrayUtils.printHexBinary(null, "OctetString real data", goal);
            opaque.setString(goal);
            dest = new byte[data.length - 1  - length.intValue()];
            System.arraycopy(data, 1 + length.intValue(), dest, 0, dest.length);
            opaque.setGoal(dest);
        } else {
            throw new Exception("该数据类型不是OctetString");
        }
        return opaque;
    }


    public byte[] readString() throws IOException {
        int len = this.readInt();
        return this.readBytes(len);
    }

    public byte[] readString(int len) throws IOException {
        return this.readBytes(len);
    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        if (this.length != -1) {
            if (string.length > this.length) {
                throw new IOException("string len:" + string.length + " is greater than " + length);
            }
        } else {
            this.setLengthPrefix(string.length);
        }
        vector.add(string);
        return vector;
    }
}
