package com.xdja.pki.itsca.oer.cert;


import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;

public class CertificateBuilder {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;

    private GeographicRegion geographicRegion;

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    /**
     * 构造 四边形区域
     *
     * @param northWestLatitude  北 西 维度
     * @param northWestLongitude 北 西 经度
     * @param southEastLatitude  南 东 纬度
     * @param southEastLongitude 南 东 经度
     * @return 四边形区域信息
     */
    public void setGeographicRegion(
            int northWestLatitude,
            int northWestLongitude,
            int southEastLatitude,
            int southEastLongitude
    ) {
        this.geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion sequenceOfRectangularRegion = new SequenceOfRectangularRegion();
        RectangularRegionBuilder rectangularRegionBuilder = new RectangularRegionBuilder();
        RectangularRegion rectangularRegion = rectangularRegionBuilder.build(northWestLatitude, northWestLongitude, southEastLatitude, southEastLongitude);
        sequenceOfRectangularRegion.addRectangularRegion(rectangularRegion);
        this.geographicRegion.setRectangularRegion(sequenceOfRectangularRegion);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, byte[] issuedHashId, Enumerated.Value subjectTypeValue) throws IOException {

        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();

        if (itsAidList != null) {
            tbsCertBuilder.setItsAidList(itsAidList);
        }
        if (itsAidSspList != null) {
            tbsCertBuilder.setItsAidSspList(itsAidSspList);
        }
        if (geographicRegion != null) {
            tbsCertBuilder.setGeographicRegion(geographicRegion);
        }

        TbsCert tbsCert = tbsCertBuilder.build(verifyPublicKey, encPublicKey, subjectName, subjectTypeValue);

        return build(privateKey, issuedHashId, tbsCert);
    }

    public Certificate build(PrivateKey privateKey, byte[] issuedHashId, TbsCert tbsCert) throws IOException {
        Certificate certificate = new Certificate();
        ByteArrayUtils.printHexBinary(0, "Certificate SEQUENCE", null);

        ByteArrayUtils.printHexBinary(1, "Version Uint8 INTEGER", null);
        ByteArrayUtils.printHexBinary(1, "Version", ByteBuffer.allocate(2).putShort((short) 2).array());

        IssuerId issuerId = new IssuerId();
        if (issuedHashId != null) {
            ByteArrayUtils.printHexBinary(1, "IssuerId CHOICE [index = 1]", null);

            ByteArrayUtils.printHexBinary(2, "CertificateDigest SEQUENCE", null);
            CertificateDigest certificateDigest = new CertificateDigest();

            ByteArrayUtils.printHexBinary(3, "HashAlgorithm ENUMERATED", null);
            HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
            certificateDigest.setHashAlgorithm(hashAlgorithm);
            ByteArrayUtils.printHexBinary(3, "HashAlgorithm", hashAlgorithm.getEncode());

            ByteArrayUtils.printHexBinary(3, "HashedId8 OCTER STRING", null);
            HashedId8 hashedId8 = new HashedId8(issuedHashId);
            certificateDigest.setHashedId8(hashedId8);
            ByteArrayUtils.printHexBinary(3, "HashedId8", hashedId8.getEncode());

            ByteArrayUtils.printHexBinary(2, "CertificateDigest", certificateDigest.getEncode());
            issuerId.setCertificateDigest(certificateDigest);
        } else {
            ByteArrayUtils.printHexBinary(1, "IssuerId CHOICE [index = 0]", null);
            Null aNull = new Null();
            issuerId.setSelf(aNull);
        }
        certificate.setIssuerId(issuerId);
        ByteArrayUtils.printHexBinary(1, "IssuerId", issuerId.getEncode());

        ByteArrayUtils.printHexBinary(1, "TbsCert", null);
        certificate.setTbsCert(tbsCert);
        ByteArrayUtils.printHexBinary(1, "TbsCert", tbsCert.getEncode());

        byte[] tbsEncode = tbsCert.getEncode();
        byte[] r;
        byte[] s;
        try {
            byte[] sign;
//            if (privateKey instanceof SdfPrivateKey) {
//                sign = GMSSLSM2SignUtils.signBySdf(SdfCryptoType.YUNHSM, ((SdfPrivateKey) privateKey).getIndex(), new String(((SdfPrivateKey) privateKey).getPassword()), tbsEncode);
//            }else {
                sign = BCUtils.sm2SignByBC(privateKey, tbsEncode);
   //         }
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert derDecode != null && derDecode.length == 2;
            r = derDecode[0];
            s = derDecode[1];
        } catch (Exception e) {
            throw new IOException(e);
        }
        Signature signature = new Signature();
        EccCurve eccCurve = new EccCurve(EccCurve.SGD_SM2);
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        signature.setS(s);
        certificate.setSignature(signature);
        ByteArrayUtils.printHexBinary(1, "Signature", signature.getEncode());
        ByteArrayUtils.printHexBinary(0, "Certificate", certificate.getEncode());

        return certificate;
    }

}
