package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;


/**
 * 获取证书详情
 */
public class CertificateHolder {
    public static OERCertificate build(byte[] data) throws Exception {
        Certificate certificate = Certificate.getInstance(data);
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x80) {
            byte[] bytes = BCUtils.sm3DigestByBC(certificate.getEncode());
            byte[] goal = new byte[8];
            System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
            signerHashId8 = ByteArrayUtils.hexEncode(goal);
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = ByteArrayUtils.hexEncode(hashedId8.getString());
        }
        byte[] bytes = BCUtils.sm3DigestByBC(certificate.getEncode());
        byte[] goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        String selfHashId8 = ByteArrayUtils.hexEncode(goal);
        byte[] r = certificate.getSignature().getR().getxOnly().getString();
        byte[] s = certificate.getSignature().getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        OERCertificate oerCertificate = new OERCertificate();
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignerHashId8(signerHashId8);
        oerCertificate.setSelfHashId8(selfHashId8);
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setSignature(signature);
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setItsAid(tbsCert.getItsAid());
        oerCertificate.setNorthWestLatitude(tbsCert.getNorthWestLatitude());
        oerCertificate.setNorthWestLongitude(tbsCert.getNorthWestLongitude());
        oerCertificate.setSouthEastLatitude(tbsCert.getSouthEastLatitude());
        oerCertificate.setSouthEastLongitude(tbsCert.getSouthEastLongitude());
        return oerCertificate;
    }
}
