package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.TbsCert;

import java.security.PublicKey;
import java.util.Arrays;

/**
 * 证书详情类
 */
public class OERCertificate {
    private int version;
    private TbsCert tbsCert;
    private String subjectName;
    private String signerHashId8;
    private String selfHashId8;
    private PublicKey signPublicKey;
    private String subjectType;
    private byte[] signature;
    private String startTime;
    private String endTime;
    private int northWestLatitude;
    private int northWestLongitude;
    private int southEastLatitude;
    private int southEastLongitude;
    private String itsAid;
    private PublicKey encPublicKey;

    public int getNorthWestLatitude() {
        return northWestLatitude;
    }

    public void setNorthWestLatitude(int northWestLatitude) {
        this.northWestLatitude = northWestLatitude;
    }

    public int getNorthWestLongitude() {
        return northWestLongitude;
    }

    public void setNorthWestLongitude(int northWestLongitude) {
        this.northWestLongitude = northWestLongitude;
    }

    public int getSouthEastLatitude() {
        return southEastLatitude;
    }

    public void setSouthEastLatitude(int southEastLatitude) {
        this.southEastLatitude = southEastLatitude;
    }

    public int getSouthEastLongitude() {
        return southEastLongitude;
    }

    public void setSouthEastLongitude(int southEastLongitude) {
        this.southEastLongitude = southEastLongitude;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public byte[] getSignature() {
        return signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }


    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    public String getSignerHashId8() {
        return signerHashId8;
    }

    public void setSignerHashId8(String signerHashId8) {
        this.signerHashId8 = signerHashId8;
    }

    public TbsCert getTbsCert() {
        return tbsCert;
    }

    public void setTbsCert(TbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getItsAid() {
        return itsAid;
    }

    public void setItsAid(String itsAid) {
        this.itsAid = itsAid;
    }

    public String getSelfHashId8() {
        return selfHashId8;
    }

    public void setSelfHashId8(String selfHashId8) {
        this.selfHashId8 = selfHashId8;
    }

    public PublicKey getSignPublicKey() {
        return signPublicKey;
    }

    public void setSignPublicKey(PublicKey signPublicKey) {
        this.signPublicKey = signPublicKey;
    }

    public PublicKey getEncPublicKey() {
        return encPublicKey;
    }

    public void setEncPublicKey(PublicKey encPublicKey) {
        this.encPublicKey = encPublicKey;
    }

    @Override
    public String toString() {
        return "OERCertificate{" +
                "version=" + version +
                ", tbsCert=" + tbsCert +
                ", subjectName='" + subjectName + '\'' +
                ", signerHashId8='" + signerHashId8 + '\'' +
                ", selfHashId8='" + selfHashId8 + '\'' +
                ", signPublicKey=" + signPublicKey +
                ", subjectType='" + subjectType + '\'' +
                ", signature=" + Arrays.toString(signature) +
                ", startTime='" + startTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", northWestLatitude=" + northWestLatitude +
                ", northWestLongitude=" + northWestLongitude +
                ", southEastLatitude=" + southEastLatitude +
                ", southEastLongitude=" + southEastLongitude +
                ", itsAid='" + itsAid + '\'' +
                ", encPublicKey=" + encPublicKey +
                '}';
    }
}
