package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.Certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * SignedData详情
 */
public class OERSignedData {
    private List<OERCertificate> certificate = new ArrayList<>();
    private String signerHashId8;
    private byte[] data;
    private int itsAid;
    private String hashAlg;
    private byte[] signature;

    public byte[] getSignature() {
        return signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getHashAlg() {
        return hashAlg;
    }

    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }

    public int getItsAid() {
        return itsAid;
    }

    public void setItsAid(int itsAid) {
        this.itsAid = itsAid;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getSignerHashId8() {
        return signerHashId8;
    }

    public void setSignerHashId8(String signerHashId8) {
        this.signerHashId8 = signerHashId8;
    }

    public List<OERCertificate> getCertificate() {
        return certificate;
    }

    public void setCertificate(OERCertificate certificate) {
        this.certificate.add(certificate);
    }

    @Override
    public String toString() {
        return "OERSignedData{" +
                "certificate=" + certificate +
                ", signerHashId8='" + signerHashId8 + '\'' +
                ", data=" + Arrays.toString(data) +
                ", itsAid=" + itsAid +
                ", hashAlg='" + hashAlg + '\'' +
                ", signature=" + Arrays.toString(signature) +
                '}';
    }
}
