package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SignedData;

/**
 * SecuredMessageSignedData详情
 */
public class SecuredMessageSignedDataHolder {

    public static OERSecuredMessageSignedData build(byte[] data) throws Exception {
        SecuredMessage securedMessage = SecuredMessage.getInstance(data);
        SignedData signedData = securedMessage.getPayload().getSignedData();
        OERSignedData signData = SignedDataHolder.build(signedData.getEncode());
        int version = securedMessage.getVersion();

        OERSecuredMessageSignedData message = new OERSecuredMessageSignedData();
        message.setCertificate(signData.getCertificate());
        message.setData(signData.getData());
        message.setHashAlg(signData.getHashAlg());
        message.setItsAid(signData.getItsAid());
        message.setSignature(signData.getSignature());
        message.setSignerHashId8(signData.getSignerHashId8());
        message.setVerison(version);
        return message;
    }
}
