package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.List;

/**
 * 获取TBSCert详情
 */
public class TbsCertHolder {
    public static OERTbsCert build(byte[] data) throws Exception {
        TbsCert tbsCert = TbsCert.getInstance(data);
        OctetString subject = tbsCert.getSubjectInfo().getSubjectName();
        String subjectName = new String(subject.getString());
        PublicVerifyKey verifyKey = tbsCert.getSubjectAttribute().getVerifyKey();
        Uncompressed uncompressed = verifyKey.getEccPoint().getUncompressed();
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        PublicKey signPublicKey = X509Utils.convertSM2PublicKey(x, y);
        SubjectType subjectType = tbsCert.getSubjectInfo().getSubjectType();
        BigInteger type = BigIntegers.fromUnsignedByteArray(subjectType.getEncode());
        String subType = "";
        if (type.intValue() == 0) {
            subType = "注册CA证书";
        } else if (type.intValue() == 1) {
            subType = "授权证书";
        } else if (type.intValue() == 2) {
            subType = "授权CA证书";
        } else if (type.intValue() == 3) {
            subType = "注册证书";
        } else if (type.intValue() == 4) {
            subType = "根CA证书";
        } else if (type.intValue() == 5) {
            subType = "CRL签发证书";
        } else if (type.intValue() == 6) {
            subType = "假名证书";
        }  else if (type.intValue() == 7) {
            subType = "假名CA证书";
        } else {
            throw new Exception("unknown subject type " + type.intValue());
        }
        ValidityRestriction validityRestriction = tbsCert.getValidityRestriction();
        String startTime = "";
        String endTime = "";

        if (null != validityRestriction.getValidityPeriod().getTimeEnd()) {
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeEnd();
            BigInteger time = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            System.out.println(time);
            endTime = TimeUtils.getTime(time.longValue());
        }
        if (null != validityRestriction.getValidityPeriod().getTimeStartAndEnd()) {
            Time32 timeStart = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getStartValidity();
            BigInteger time = BigIntegers.fromUnsignedByteArray(timeStart.getEncode());
            startTime = TimeUtils.getTime(time.longValue());
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getEndValidity();
            time = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
        }
        OERTbsCert oerTbsCert = new OERTbsCert();
        try {
            RectangularRegion rectangularRegion = validityRestriction.getGeographicRegion().getRectangularRegion().getRectangularRegions().get(0);
            oerTbsCert.setNorthWestLatitude(rectangularRegion.getNorthWest().getLatitude().getValue());
            oerTbsCert.setNorthWestLongitude(rectangularRegion.getNorthWest().getLongitude().getValue());
            oerTbsCert.setSouthEastLatitude(rectangularRegion.getSouthEast().getLatitude().getValue());
            oerTbsCert.setSouthEastLongitude(rectangularRegion.getSouthEast().getLongitude().getValue());
        } catch (Exception e) {
            //   e.printStackTrace();
        }
        StringBuilder itsId = new StringBuilder();
        try {
            List<ItsAid> itsAid = tbsCert.getSubjectAttribute().getItsAidList().getItsAid();
            for (int i = 0; i < itsAid.size(); i++) {
                if (i != 0) {
                    itsId.append(";");
                }
                itsId.append(Hex.toHexString(itsAid.get(i).getEncode()));
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }

        try {
            PublicEncryptionKey encryptionKey = tbsCert.getSubjectAttribute().getEncryptionKey();
            uncompressed = encryptionKey.getPublicKey().getUncompressed();
            x = uncompressed.getX().getString();
            y = uncompressed.getY().getString();
            PublicKey encPublicKey = X509Utils.convertSM2PublicKey(x, y);
            oerTbsCert.setEncPublic(encPublicKey);
        } catch (Exception e) {
            //e.printStackTrace();
        }
        oerTbsCert.setItsAid(itsId.toString());
        oerTbsCert.setSubjectType(subType);
        oerTbsCert.setStartTime(startTime);
        oerTbsCert.setEndTime(endTime);
        oerTbsCert.setSignPublicKey(signPublicKey);
        oerTbsCert.setSubjectName(subjectName);
        return oerTbsCert;
    }
}
