/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.app.KekResolveUtils;
import com.xdja.pki.itsca.oer.asn1.AuthorizationValidationRequestEnc;
import com.xdja.pki.itsca.oer.asn1.AuthorizationValidationRequestSign;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import java.security.PrivateKey;
import java.util.List;

public class AuthorizationValidationRequestEncHolder {
    private PrivateKey ecaPrivateKey;
    private AuthorizationValidationRequestEnc enc;
    private AuthorizationValidationRequestSign sign;

    public static AuthorizationValidationRequestEnc parseBytes(byte[] encEncoding) throws Exception {
        return AuthorizationValidationRequestEnc.getInstance(encEncoding);
    }

    public AuthorizationValidationRequestEncHolder(byte[] encEncoding, PrivateKey ecaPrivateKey) throws Exception {
        this(AuthorizationValidationRequestEncHolder.parseBytes(encEncoding), ecaPrivateKey);
    }

    public AuthorizationValidationRequestEncHolder(AuthorizationValidationRequestEnc enc, PrivateKey ecaPrivateKey) throws Exception {
        this.enc = enc;
        this.ecaPrivateKey = ecaPrivateKey;
        Payload payload = this.enc.getPayload();
        EncryptedData encData = payload.getEncData();
        SequenceOfRecipientInfo recipients = encData.getRecipients();
        List<RecipientInfo> recipientInfos = recipients.getRecipientInfos();
        for (RecipientInfo recipientInfo : recipientInfos) {
            PKRecipientInfo certRecipInfo = recipientInfo.getCertRecipInfo();
            EciesEncryptedKey kek = certRecipInfo.getKek();
            byte[] plain = KekResolveUtils.getPlain(kek, ecaPrivateKey);
            this.sign = AuthorizationValidationRequestSign.getInstance(plain);
        }
        throw new Exception("can`t decode enc data");
    }

    public int getVersion() {
        return this.enc.getVersion();
    }

    public AuthorizationValidationRequestEnc getEnc() {
        return this.enc;
    }

    public AuthorizationValidationRequestSign getSign() throws Exception {
        return this.sign;
    }
}

