/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.ATSubjectAttributes;
import com.xdja.pki.itsca.oer.asn1.ATTbsCert;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SubjectAssurance;
import com.xdja.pki.itsca.oer.asn1.SubjectInfo;
import com.xdja.pki.itsca.oer.asn1.SubjectType;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TimeStartAndEnd;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.ValidityRestriction;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.IOException;

public class ATTbsCertBuilder {
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;
    private GeographicRegion geographicRegion;

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public ATTbsCert build(String subjectName) throws IOException {
        ATTbsCert atTbsCert = new ATTbsCert();
        SubjectInfo subjectInfo = new SubjectInfo();
        subjectInfo.setSubjectType(new SubjectType(SubjectType.AUTHORIZATION_TICKET));
        subjectInfo.setSubjectName(subjectName.getBytes());
        atTbsCert.setSubjectInfo(subjectInfo);
        ATSubjectAttributes subjectAttribute = new ATSubjectAttributes();
        subjectAttribute.setAssuranceLevel(new SubjectAssurance("0".getBytes()));
        if (this.itsAidList != null) {
            subjectAttribute.setItsAidList(this.itsAidList);
        }
        if (this.itsAidSspList != null) {
            subjectAttribute.setItsSspList(this.itsAidSspList);
        }
        atTbsCert.setSubjectAttributes(subjectAttribute);
        ValidityRestriction validityRestriction = new ValidityRestriction();
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd startAndEnd = new TimeStartAndEnd();
        long nowTime = TimeUtils.getNowTime();
        Time32 time32 = new Time32(nowTime);
        startAndEnd.setStartValidity(time32);
        long timeEnd = TimeUtils.getTimeAfterYear(1);
        time32 = new Time32(timeEnd);
        startAndEnd.setEndValidity(time32);
        validityPeriod.setTimeStartAndEnd(startAndEnd);
        validityRestriction.setValidityPeriod(validityPeriod);
        if (this.geographicRegion != null) {
            validityRestriction.setGeographicRegion(this.geographicRegion);
        }
        atTbsCert.setValidityRestrictions(validityRestriction);
        return atTbsCert;
    }
}

