/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKRecipientInfo
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PKRecipientInfo.class);
    private HashAlgorithm hashAlg;
    private HashedId8 recipientId;
    private EciesEncryptedKey kek;

    public PKRecipientInfo() {
        super(false, false);
    }

    public static PKRecipientInfo getInstance(byte[] data) throws Exception {
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();
        ByteArrayUtils.printHexBinary(logger, "PKRecipientInfo  start data ", data);
        BigInteger hashAlgorithm = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (hashAlgorithm.intValue() == HashAlgorithm.SGD_SM3.getIndex()) {
            pkRecipientInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
        } else if (hashAlgorithm.intValue() == HashAlgorithm.SHA_256.getIndex()) {
            pkRecipientInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SHA_256));
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301\u7c7b\u578b");
        }
        byte[] hashedId8 = new byte[8];
        System.arraycopy(data, 1, hashedId8, 0, hashedId8.length);
        pkRecipientInfo.setRecipientId(new HashedId8(hashedId8));
        ByteArrayUtils.printHexBinary(logger, "PKRecipientInfo HashedId8 data ", hashedId8);
        byte[] goal = new byte[data.length - 9];
        System.arraycopy(data, 9, goal, 0, goal.length);
        EciesEncryptedKey instance = EciesEncryptedKey.getInstance(goal);
        ByteArrayUtils.printHexBinary(logger, "PKRecipientInfo EciesEncryptedKey data ", instance.getEncode());
        pkRecipientInfo.setKek(instance);
        pkRecipientInfo.setGoal(instance.getGoal());
        ByteArrayUtils.printHexBinary(logger, "PKRecipientInfo lave data ", pkRecipientInfo.getGoal());
        return pkRecipientInfo;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setRecipientId(HashedId8 recipientId) {
        this.recipientId = recipientId;
    }

    public void setKek(EciesEncryptedKey kek) {
        this.kek = kek;
    }

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    public HashedId8 getRecipientId() {
        return this.recipientId;
    }

    public EciesEncryptedKey getKek() {
        return this.kek;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.hashAlg);
        vector.add(this.recipientId);
        vector.add(this.kek);
        return vector;
    }
}

