/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicVerifyKey
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PublicVerifyKey.class);
    private EccCurve eccCurve;
    private EccPoint eccPoint;

    public PublicVerifyKey() {
        super(true, false);
    }

    public static PublicVerifyKey getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey start data", data);
        BigInteger extension = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey publicVerifyKey = new PublicVerifyKey();
        EccCurve eccCurve = EccCurve.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey eccCurve data", eccCurve.getEncode());
        data = eccCurve.getGoal();
        EccPoint eccPoint = EccPoint.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey eccPoint data", eccPoint.getEncode());
        publicVerifyKey.setEccCurve(eccCurve);
        publicVerifyKey.setEccPoint(eccPoint);
        publicVerifyKey.setGoal(eccPoint.getGoal());
        if (extension.intValue() == 128) {
            // empty if block
        }
        ByteArrayUtils.printHexBinary(logger, " PublicVerifyKey lave data", publicVerifyKey.getGoal());
        return publicVerifyKey;
    }

    public EccCurve getEccCurve() {
        return this.eccCurve;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public EccPoint getEccPoint() {
        return this.eccPoint;
    }

    public void setEccPoint(EccPoint eccPoint) {
        this.eccPoint = eccPoint;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.eccCurve);
        vector.add(this.eccPoint);
        return vector;
    }
}

