/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedData
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SignedData.class);
    private SignerInfo signerInfo;
    private TBSData tbs;
    private Signature sign;

    public SignedData() {
        super(false, false);
    }

    public static SignedData getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SignedData start data ", data);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        SignedData signedData = new SignedData();
        SignerInfo signerInfo = SignerInfo.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "SignedData signerInfo data ", signerInfo.getEncode());
        signedData.setSignerInfo(signerInfo);
        data = signerInfo.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SignedData data ", data);
        TBSData tbsData = TBSData.getInstance(data);
        signedData.setTbs(tbsData);
        data = tbsData.getGoal();
        ByteArrayUtils.printHexBinary(logger, "TBSData data ", data);
        Signature signature = Signature.getInstance(data);
        signedData.setSign(signature);
        signedData.setGoal(signature.getGoal());
        return signedData;
    }

    public void setSignerInfo(SignerInfo signerInfo) {
        this.signerInfo = signerInfo;
    }

    public void setTbs(TBSData tbs) {
        this.tbs = tbs;
    }

    public void setSign(Signature sign) {
        this.sign = sign;
    }

    public SignerInfo getSignerInfo() {
        return this.signerInfo;
    }

    public TBSData getTbs() {
        return this.tbs;
    }

    public Signature getSign() {
        return this.sign;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.signerInfo);
        vector.add(this.tbs);
        vector.add(this.sign);
        return vector;
    }
}

