/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmRecipInfo
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SymmRecipInfo.class);
    private HashAlgorithm hashAlg;
    private HashedId8 recipientId;
    private SymmetricCipherText encKey;

    public SymmRecipInfo() {
        super(false, false);
    }

    public static SymmRecipInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo start data", data);
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        SymmRecipInfo symmRecipInfo = new SymmRecipInfo();
        symmRecipInfo.setHashAlg(hashAlgorithm);
        data = hashAlgorithm.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo hashAlg data", hashAlgorithm.getEncode());
        HashedId8 hashedId8 = HashedId8.getInstance(data);
        symmRecipInfo.setRecipientId(hashedId8);
        data = hashedId8.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo recipientId data", hashedId8.getEncode());
        SymmetricCipherText encKey = SymmetricCipherText.getInstance(data);
        symmRecipInfo.setEncKey(encKey);
        symmRecipInfo.setGoal(encKey.getGoal());
        ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo encKey data", encKey.getEncode());
        ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo lave data", symmRecipInfo.getGoal());
        return null;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setRecipientId(HashedId8 recipientId) {
        this.recipientId = recipientId;
    }

    public void setEncKey(SymmetricCipherText encKey) {
        this.encKey = encKey;
    }

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    public HashedId8 getRecipientId() {
        return this.recipientId;
    }

    public SymmetricCipherText getEncKey() {
        return this.encKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.hashAlg);
        vector.add(this.recipientId);
        vector.add(this.encKey);
        return vector;
    }
}

