/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OERObject {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ByteArrayInputStream reader;
    private int offset = 0;
    private int lengthPrefix = -1;
    protected byte[] goal;

    public byte[] getGoal() {
        return this.goal;
    }

    public void setGoal(byte[] goal) {
        this.goal = goal;
    }

    protected static byte[] subByteData(byte[] source, int srcPos, int len) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(source);
        byteArrayInputStream.read();
        OERObject oerObject = new OERObject(){

            @Override
            public Vector getValues() throws IOException {
                return new Vector();
            }
        };
        return super.subByte(source, srcPos, len);
    }

    private byte[] subByte(byte[] source, int srcPos, int len) {
        byte[] goal = new byte[len];
        System.arraycopy(source, srcPos, goal, 0, len);
        byte[] lave = new byte[source.length - len - srcPos];
        System.arraycopy(source, srcPos + len, lave, 0, lave.length);
        source = lave;
        return goal;
    }

    public int getLengthPrefix() {
        return this.lengthPrefix;
    }

    public void setLengthPrefix(int lengthPrefix) {
        this.lengthPrefix = lengthPrefix;
    }

    public void fromByteArray(byte[] obj) {
        this.reader = new ByteArrayInputStream(obj);
    }

    public int readInt() throws IOException {
        BigInteger len = BigIntegers.fromUnsignedByteArray((byte[])this.getEncode(), (int)0, (int)1);
        BigInteger length = BigIntegers.fromUnsignedByteArray((byte[])this.getEncode(), (int)1, (int)(len.intValue() - 128));
        return length.intValue();
    }

    public byte readByte() throws IOException {
        if (this.reader == null) {
            this.reader = new ByteArrayInputStream(this.getEncode());
        }
        return this.readBytes(1)[0];
    }

    public byte[] readBytes(int len) throws IOException {
        if (this.reader == null) {
            this.reader = new ByteArrayInputStream(this.getEncode());
        }
        byte[] bytes = new byte[len];
        this.reader.read(bytes, this.offset, bytes.length);
        ++this.offset;
        return bytes;
    }

    public abstract Vector getValues() throws IOException;

    private void writeLengthPrefix(ByteArrayOutputStream writer) throws IOException {
        int len = this.getLengthPrefix();
        if (len == -1) {
            return;
        }
        if (len > 127) {
            BigInteger lenBigInteger = BigInteger.valueOf(len);
            byte[] lenBytes = BigIntegers.asUnsignedByteArray((BigInteger)lenBigInteger);
            int lenLength = lenBytes.length;
            BigInteger lenLengthBigInteger = BigInteger.valueOf(lenLength);
            byte[] lenLengthBytes = BigIntegers.asUnsignedByteArray((BigInteger)lenLengthBigInteger);
            BitSet bitSet = BitSet.valueOf(lenLengthBytes);
            bitSet.set(7);
            byte[] bitSetBytes = bitSet.toByteArray();
            writer.write(bitSetBytes);
            writer.write(lenBytes);
        } else {
            writer.write(len);
        }
    }

    public byte[] getEncode() throws IOException {
        Vector vector = this.getValues();
        if (vector == null) {
            return new byte[0];
        }
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        this.writeLengthPrefix(writer);
        for (Object obj : vector) {
            if (obj == null) continue;
            if (obj instanceof Integer) {
                writer.write((Integer)obj);
            }
            if (obj instanceof Byte) {
                writer.write(((Byte)obj).byteValue());
            }
            if (obj instanceof byte[]) {
                writer.write((byte[])obj);
            }
            if (!(obj instanceof OERObject)) continue;
            writer.write(((OERObject)obj).getEncode());
        }
        return writer.toByteArray();
    }
}

