/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.CircularRegion;
import com.xdja.pki.itsca.oer.asn1.ItsAid;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SubjectType;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TwoDLocation;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.asn1.ValidityRestriction;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.cert.bean.GeographicRegionType;
import com.xdja.pki.itsca.oer.cert.bean.OERCircularRegion;
import com.xdja.pki.itsca.oer.cert.bean.OERPolygonalRegion;
import com.xdja.pki.itsca.oer.cert.bean.OERRectangularRegion;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class TbsCertHolder {
    public static OERTbsCert build(byte[] data) throws Exception {
        Object region;
        ArrayList<OERRectangularRegion> regions;
        BigInteger time;
        TbsCert tbsCert = TbsCert.getInstance(data);
        OctetString subject = tbsCert.getSubjectInfo().getSubjectName();
        String subjectName = new String(subject.getString());
        PublicVerifyKey verifyKey = tbsCert.getSubjectAttribute().getVerifyKey();
        Uncompressed uncompressed = verifyKey.getEccPoint().getUncompressed();
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        PublicKey signPublicKey = X509Utils.convertSM2PublicKey(x, y);
        SubjectType subjectType = tbsCert.getSubjectInfo().getSubjectType();
        BigInteger type = BigIntegers.fromUnsignedByteArray((byte[])subjectType.getEncode());
        String subType = "";
        if (type.intValue() == 0) {
            subType = "\u6ce8\u518c\u8bc1\u4e66";
        } else if (type.intValue() == 1) {
            subType = "\u6388\u6743\u8bc1\u4e66";
        } else if (type.intValue() == 2) {
            subType = "\u6388\u6743CA\u8bc1\u4e66";
        } else if (type.intValue() == 3) {
            subType = "\u6ce8\u518cCA\u8bc1\u4e66";
        } else if (type.intValue() == 4) {
            subType = "\u6839CA\u8bc1\u4e66";
        } else if (type.intValue() == 5) {
            subType = "CRL\u7b7e\u53d1\u8bc1\u4e66";
        } else if (type.intValue() == 6) {
            subType = "\u5047\u540d\u8bc1\u4e66";
        } else if (type.intValue() == 7) {
            subType = "\u5047\u540dCA\u8bc1\u4e66";
        } else {
            throw new Exception("unknown subject type " + type.intValue());
        }
        ValidityRestriction validityRestriction = tbsCert.getValidityRestriction();
        String startTime = "";
        String endTime = "";
        if (null != validityRestriction.getValidityPeriod().getTimeEnd()) {
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeEnd();
            time = BigIntegers.fromUnsignedByteArray((byte[])timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
        }
        if (null != validityRestriction.getValidityPeriod().getTimeStartAndEnd()) {
            Time32 timeStart = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getStartValidity();
            time = BigIntegers.fromUnsignedByteArray((byte[])timeStart.getEncode());
            startTime = TimeUtils.getTime(time.longValue());
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getEndValidity();
            time = BigIntegers.fromUnsignedByteArray((byte[])timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
        }
        OERTbsCert oerTbsCert = new OERTbsCert();
        try {
            List<RectangularRegion> rectangularRegions = validityRestriction.getGeographicRegion().getRectangularRegion().getRectangularRegions();
            regions = new ArrayList<OERRectangularRegion>();
            for (RectangularRegion rectangularRegion : rectangularRegions) {
                region = new OERRectangularRegion();
                ((OERRectangularRegion)region).setNorthWestLatitude(rectangularRegion.getNorthWest().getLatitude().getValue());
                ((OERRectangularRegion)region).setNorthWestLongitude(rectangularRegion.getNorthWest().getLongitude().getValue());
                ((OERRectangularRegion)region).setSouthEastLatitude(rectangularRegion.getSouthEast().getLatitude().getValue());
                ((OERRectangularRegion)region).setSouthEastLongitude(rectangularRegion.getSouthEast().getLongitude().getValue());
                regions.add((OERRectangularRegion)region);
            }
            oerTbsCert.setRectangularRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.RECTANGULAR_REGION);
        }
        catch (Exception rectangularRegions) {
            // empty catch block
        }
        try {
            CircularRegion circularRegion = validityRestriction.getGeographicRegion().getCircularRegion();
            OERCircularRegion region2 = new OERCircularRegion();
            BigInteger r = BigIntegers.fromUnsignedByteArray((byte[])circularRegion.getRadius().getEncode());
            region2.setR(r.intValue());
            region2.setLatitude(circularRegion.getCenter().getLatitude().getValue());
            region2.setLongitude(circularRegion.getCenter().getLongitude().getValue());
            oerTbsCert.setCircularRegion(region2);
            oerTbsCert.setRegionType(GeographicRegionType.CIRCULAR_REGION);
        }
        catch (Exception circularRegion) {
            // empty catch block
        }
        try {
            List<TwoDLocation> twoDLocations = validityRestriction.getGeographicRegion().getPolygonalRegion().getTwoDLocations();
            regions = new ArrayList();
            for (TwoDLocation twoDLocation : twoDLocations) {
                region = new OERPolygonalRegion();
                ((OERPolygonalRegion)region).setLatitude(twoDLocation.getLatitude().getValue());
                ((OERPolygonalRegion)region).setLongitude(twoDLocation.getLongitude().getValue());
                regions.add((OERRectangularRegion)region);
            }
            oerTbsCert.setPolygonalRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.POLYGONAL_REGION);
        }
        catch (Exception twoDLocations) {
            // empty catch block
        }
        StringBuilder itsId = new StringBuilder();
        try {
            List<ItsAid> itsAid = tbsCert.getSubjectAttribute().getItsAidList().getItsAid();
            for (int i = 0; i < itsAid.size(); ++i) {
                if (i != 0) {
                    itsId.append(";");
                }
                itsId.append(Hex.toHexString((byte[])itsAid.get(i).getEncode()));
            }
        }
        catch (Exception itsAid) {
            // empty catch block
        }
        try {
            PublicEncryptionKey encryptionKey = tbsCert.getSubjectAttribute().getEncryptionKey();
            uncompressed = encryptionKey.getPublicKey().getUncompressed();
            x = uncompressed.getX().getString();
            y = uncompressed.getY().getString();
            PublicKey encPublicKey = X509Utils.convertSM2PublicKey(x, y);
            oerTbsCert.setEncPublic(encPublicKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        oerTbsCert.setItsAid(itsId.toString());
        oerTbsCert.setSubjectType(subType);
        oerTbsCert.setStartTime(startTime);
        oerTbsCert.setEndTime(endTime);
        oerTbsCert.setSignPublicKey(signPublicKey);
        oerTbsCert.setSubjectName(subjectName);
        return oerTbsCert;
    }
}

