/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayUtils {
    private static Logger logger = LoggerFactory.getLogger((String)X509Utils.class.getName());
    public static int printTag = -1;

    public static byte[] buildUpByte(byte[] var1, byte[] var2) {
        byte[] data = new byte[var1.length + var2.length];
        System.arraycopy(var1, 0, data, 0, var1.length);
        System.arraycopy(var2, 0, data, var1.length, var2.length);
        return data;
    }

    public static String splitPublicKey(PublicKey publicKey, String segmentation) {
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        byte[] x = BigIntegers.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineY());
        String xx = Hex.toHexString((byte[])x);
        int xLength = xx.length();
        if (xx.length() < 64) {
            for (int i = xLength; i < 64; ++i) {
                xx = "0" + xx;
            }
        }
        String yy = Hex.toHexString((byte[])y);
        int yLength = yy.length();
        if (yy.length() < 64) {
            for (int i = yLength; i < 64; ++i) {
                yy = "0" + yy;
            }
        }
        return xx + segmentation + yy;
    }

    public static byte[] getHashId(byte[] data, int len) throws Exception {
        byte[] hash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])data);
        byte[] bytes = new byte[len];
        System.arraycopy(hash, hash.length - len, bytes, 0, bytes.length);
        return data;
    }

    public static byte[] hexDecode(String hexData) {
        return Hex.decode((String)hexData);
    }

    public static String hexEncode(byte[] data) {
        return Hex.toHexString((byte[])data);
    }

    public static String hexEncodeSubString(byte[] data) {
        ArrayList<String> list = new ArrayList<String>();
        String hexString = Hex.toHexString((byte[])data);
        for (int i = 0; i <= hexString.length() / 8; ++i) {
            int start = i * 8;
            int end = start + 8;
            if (end > hexString.length() - 1) {
                end = hexString.length();
            }
            String substring = hexString.substring(start, end);
            list.add(substring);
        }
        return String.join((CharSequence)" ", list);
    }

    public static String hexEncode(BigInteger data) {
        return ByteArrayUtils.hexEncode(ByteArrayUtils.asUnsignedByteArray32(data));
    }

    public static void printHexBinary(int tab, String message, byte[] data) {
        if (printTag == -1) {
            return;
        }
        if (tab > printTag) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tab; ++i) {
            sb.append("|  ");
        }
        if (data != null) {
            sb.append(": ");
            sb.append(message);
            sb.append(" [length=");
            sb.append(data.length);
            sb.append("] 0x ");
            sb.append(ByteArrayUtils.hexEncodeSubString(data));
            System.out.println(sb.toString());
        } else {
            sb.append(message);
            System.out.println(sb.toString());
        }
    }

    public static void printHexBinary(Logger log, String message, byte[] data) {
        if (log != null) {
            log.debug(message + " >> Hex len : " + data.length + " data : " + ByteArrayUtils.hexEncode(data));
        } else {
            logger.debug(message + " >> Hex len : " + data.length + " data : " + ByteArrayUtils.hexEncode(data));
        }
    }

    public static boolean compareHexBinary(Logger log, String message, String hexData, byte[] data) {
        boolean equals = Arrays.equals(ByteArrayUtils.hexDecode(hexData), data);
        String s = ByteArrayUtils.hexEncode(data);
        if (log != null) {
            log.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        } else {
            logger.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        }
        return equals;
    }

    public static byte[] base64Decode(String base64Data) {
        return Base64.decode((String)base64Data);
    }

    public static String base64Encode(byte[] data) {
        return Base64.toBase64String((byte[])data);
    }

    public static void printBase64Binary(Logger log, String message, byte[] data) {
        if (log != null) {
            log.debug(message + " >> Base64 len : " + data.length + " data : " + ByteArrayUtils.base64Encode(data));
        } else {
            logger.debug(message + " >> Base64 len : " + data.length + " data : " + ByteArrayUtils.base64Encode(data));
        }
    }

    public static String asciiToHex(String asciiValue) {
        char[] chars = asciiValue.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            hex.append(Integer.toHexString(chars[i]));
        }
        return hex.toString();
    }

    public static String hexToASCII(String hexValue) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexValue.length(); i += 2) {
            String str = hexValue.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss) {
        return ByteArrayUtils.fillByteArrayWithZeroInFoot(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, 0, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss) {
        return ByteArrayUtils.filterByteArrayZeroInFoot(ss, 32);
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, 0, bs, 0, len);
        return bs;
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss) {
        return ByteArrayUtils.fillByteArrayWithZeroInHead(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss) {
        return ByteArrayUtils.filterByteArrayZeroInHead(ss, 32);
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, ss.length - len, bs, 0, len);
        return bs;
    }

    public static byte[] asUnsignedByteArray32(BigInteger value) {
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)value);
    }
}

