package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;

import java.security.PrivateKey;

/***
 * ECA 调用 生成证书申请 返回消息 结构体
 */
public class AuthorizationValidationResponseEncBuilder {

    /**
     * ECA -> PCA 证书申请 返回 消息体生成
     *
     * @param ecaPrivateKey  ECA 证书私钥
     * @param ecaCertificate ECA 证书
     * @param pcaCertificate PCA 证书
     * @param requestHash    请求的 hash
     * @param responseCode   响应的返回值 0 成功 其他暂时失败
     * @return PCA -> ECA 证书申请 返回 消息体
     * @throws Exception 生成异常
     */
    public static SecuredMessage builder(
            PrivateKey ecaPrivateKey,
            Certificate ecaCertificate,
            Certificate pcaCertificate,
            OctetString requestHash,
            Int responseCode,
            ATSubjectAttributes confirmedSubjectAttributes,
            GeographicRegion region
    ) throws Exception {
        AuthorizationValidationResponse response = new AuthorizationValidationResponse(requestHash.getString(), responseCode.getValue(), confirmedSubjectAttributes, region);
        // ECA 证书私钥签名
        SecuredMessage sign = SecuredMessageBuilder.buildSignedDataSecuredMessage(
                ItsAidInt.NON_REGISTRATION_CERTIFICATE_REQUEST,
                ecaPrivateKey,
                pcaCertificate,
                response.getEncode()
        );
        // PCA 证书公钥加密
        return  SecuredMessageBuilder.buildEncryptedDataSecuredMessage(pcaCertificate, sign.getEncode());
    }

}