package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;

import java.security.PrivateKey;

/***
 *注册证书是终端的第一个证书，其申请采用自签名模式，注册证书请求的数据格式为SecureMessage结构，
 * EnrollmentCertRequestData ::= SecureMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				self
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid(40961),
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey ABSENT
 *                }),
 * 				data(CONTAINING CertRequest(WITH COMPONENTS { ...,
 * 					version(2),
 * 					tbsData(WITH COMPONENTS { ...,
 * 						subjectAttributes(WITH COMPONENTS { ...,
 * 				            assuranceLevel ABSENT,
 * 				            itsAidList ABSENT,
 * 				            itsAidSspList ABSENT
 *                        }),
 * 						validityRestrictions(WITH COMPONENTS { ...,
 * 				            region PRESENT
 *                        })
 *                    }),
 * 					encryptionKey PRESENT
 *                })),
 * 				extHash  ABSENT
 *            })* 		})
 *    })
 * })
 */
public class EnrollmentCertRequestBuilder extends SecuredMessageBuild {

    /**
     * @param certRequest 证书请求
     * @param privateKey  私钥签名使用
     *
     * @return EnrollmentCertRequest   F.2.1　注册证书请求数据格式
     */
    public SecuredMessage build(PrivateKey privateKey, CertRequest certRequest) throws Exception {
        logger.info("开始构建注册证书请求数据");
        return super.build(privateKey, certRequest, 40961);
    }
}
