package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import org.bouncycastle.util.BigIntegers;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

/***
 * InnerATRequest := SEQUENCE{
 *     verificationKey PublicVerifyKey,
 *     encryptionKey PublicEncryptionKey,
 *     sharedATRequest SharedATRequest,
 *     ecSignature EcSignature  ---为 “3.ECA加密身份验证消息体”
 * }
 */
public class InnerATRequestBuilder {
    public static InnerATRequest build(PublicKey signPublicKey, PublicKey encPublicKey, PublicKey snapPublicKey, EcSignature ecSignature, ATTbsCert atTbsCert) throws IOException {

        SharedATRequest sharedATRequest = new SharedATRequest();
        sharedATRequest.setCurrentTime(new Time32(TimeUtils.getNowTime()));
        PublicEncryptionKey snapPublic = new PublicEncryptionKey();
        snapPublic.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        snapPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        snapPublic.setPublicKey(buildEccPoint(snapPublicKey));
        sharedATRequest.setEncryptionKey(snapPublic);
        sharedATRequest.setTbsCert(atTbsCert);
        return build(signPublicKey, encPublicKey, ecSignature, sharedATRequest);
    }

    public static InnerATRequest build(PublicKey signPublicKey, PublicKey encPublicKey,  EcSignature ecSignature, SharedATRequest sharedATRequest) throws IOException {
        InnerATRequest innerATRequest = new InnerATRequest();
        innerATRequest.setEcSignature(ecSignature);
        innerATRequest.setSharedATRequest(sharedATRequest);
        PublicEncryptionKey encPublic = new PublicEncryptionKey();
        encPublic.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        encPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        encPublic.setPublicKey(buildEccPoint(encPublicKey));
        innerATRequest.setEncryptionKey(encPublic);
        PublicVerifyKey signPublic = new PublicVerifyKey();
        signPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        signPublic.setEccPoint(buildEccPoint(signPublicKey));
        innerATRequest.setVerificationKey(signPublic);
        return innerATRequest;
    }

    public static EccPoint buildEccPoint(PublicKey publicKey) {
        EccPoint eccPoint = new EccPoint();
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey snapKey = (ECPublicKey) publicKey;
        byte[] x = BigIntegers.asUnsignedByteArray(snapKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray(snapKey.getW().getAffineY());
        uncompressed.setX(x);
        uncompressed.setY(y);
        eccPoint.setUncompressed(uncompressed);
        return eccPoint;

    }
}
