package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;

/***
 *ATTbsCert ::= SEQUENCE {
 *     subjectInfo             SubjectInfo,
 *     subjectAttributes       ATSubjectAttributes,
 *     validityRestrictions    ValidityRestriction
 * }
 */
public class ATTbsCert extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ATTbsCert.class);
    private SubjectInfo subjectInfo;
    private ATSubjectAttributes subjectAttributes;
    private ValidityRestriction validityRestrictions;

    public ATTbsCert() {
        super(false, false);
    }

    public static ATTbsCert getInstance(byte[] data) throws Exception {
        ATTbsCert atTbsCert = new ATTbsCert();
        ByteArrayUtils.printHexBinary(logger, "ATTbsCert start data", data);
        SubjectInfo subjectInfo = SubjectInfo.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "ATTbsCert subjectInfo data", subjectInfo.getEncode());
        atTbsCert.setSubjectInfo(subjectInfo);
        data = subjectInfo.getGoal();
        ATSubjectAttributes subjectAttributes = ATSubjectAttributes.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "ATTbsCert subjectAttributes data", subjectAttributes.getEncode());
        atTbsCert.setSubjectAttributes(subjectAttributes);
        data = subjectAttributes.getGoal();
        ValidityRestriction validityRestriction = ValidityRestriction.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "ATTbsCert validityRestriction data", validityRestriction.getEncode());
        atTbsCert.setValidityRestrictions(validityRestriction);
        data = validityRestriction.getGoal();
        ByteArrayUtils.printHexBinary(logger, "ATTbsCert lave data", data);
        atTbsCert.setGoal(data);
        return atTbsCert;
    }


    public SubjectInfo getSubjectInfo() {
        return subjectInfo;
    }

    public void setSubjectInfo(SubjectInfo subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public ATSubjectAttributes getSubjectAttributes() {
        return subjectAttributes;
    }

    public void setSubjectAttributes(ATSubjectAttributes subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    public ValidityRestriction getValidityRestrictions() {
        return validityRestrictions;
    }

    public void setValidityRestrictions(ValidityRestriction validityRestrictions) {
        this.validityRestrictions = validityRestrictions;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(subjectInfo);
        vector.add(subjectAttributes);
        vector.add(validityRestrictions);
        return vector;
    }
}
