package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint16;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/***
 * -- 6.2.1.11 圆形区域
 *
 * CircularRegion ::= SEQUENCE {
 *     center  TwoDLocation,
 *     radius  Uint16
 * }
 *
 */
public class CircularRegion extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(CircularRegion.class);

    private TwoDLocation center;
    private Uint16 radius;

    public CircularRegion() {
        super(false, false);
    }

    public static CircularRegion getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "CircularRegion start data", data);
        TwoDLocation twoDLocation = TwoDLocation.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "CircularRegion twoDLocation data", twoDLocation.getEncode());
        data = twoDLocation.getGoal();

        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 2);
        Uint16 uint16 = new Uint16(integer.intValue());
        ByteArrayUtils.printHexBinary(logger, "CircularRegion Uint16 data", uint16.getEncode());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        data = goal;
        CircularRegion circularRegion = new CircularRegion();
        circularRegion.setCenter(twoDLocation);
        circularRegion.setRadius(uint16);
        circularRegion.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "CircularRegion lave data", circularRegion.getGoal());
        return circularRegion;
    }

    public TwoDLocation getCenter() {
        return center;
    }

    public void setCenter(TwoDLocation center) {
        this.center = center;
    }

    public Uint16 getRadius() {
        return radius;
    }

    public void setRadius(Uint16 radius) {
        this.radius = radius;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(center);
        vector.add(radius);
        return vector;
    }
}
