package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Int;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class ItsAidInt extends Int {

    //  安全功能预留 Safety function reservation
    public static ItsAidInt SAFETY_FUNCTION_RESERVATION;
    //  通用注册证书申请 Application for general registration certificate
    public static ItsAidInt REGISTRATION_CERTIFICATE_REQUEST;
    //  通用注册证书应答 General certificate of registration response
    public static ItsAidInt REGISTRATION_CERTIFICATE_RESPONSE;
    //  通用非注册证书申请 Application for general non-registration certificate
    public static ItsAidInt NON_REGISTRATION_CERTIFICATE_REQUEST;
    //  通用非注册证书应答 General unregistered certificate response
    public static ItsAidInt NON_REGISTRATION_CERTIFICATE_RESPONSE;
    //  证书吊销列表 crl
    public static ItsAidInt CRL;
    //  密钥协商 key agreement
    public static ItsAidInt KEY_AGREEMENT;

    //自定义扩展

    // 红绿灯应用 Traffic light application
    public static ItsAidInt TRAFFIC_LIGHT_APPLICATION;

    private static final Logger logger = LoggerFactory.getLogger(ItsAidInt.class.getName());

    static {
        try {
            SAFETY_FUNCTION_RESERVATION = new ItsAidInt(40960); // 0xa000
            REGISTRATION_CERTIFICATE_REQUEST = new ItsAidInt(40961); // 0xa001
            REGISTRATION_CERTIFICATE_RESPONSE = new ItsAidInt(40962); // 0xa002
            NON_REGISTRATION_CERTIFICATE_REQUEST = new ItsAidInt(40963); // 0xa003
            NON_REGISTRATION_CERTIFICATE_RESPONSE = new ItsAidInt(40964); // 0xa004
            CRL = new ItsAidInt(41216); // 0xa100
            KEY_AGREEMENT = new ItsAidInt(41472); // 0xa200

            //  自定义扩展
            TRAFFIC_LIGHT_APPLICATION = new ItsAidInt(45057); // Oxb001
        } catch (IOException e) {
            logger.error("generate its aid error", e);
        }
    }

    public ItsAidInt(long l) throws IOException {
        super(l);
    }

}
