package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.cert.bean.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;


/**
 * 获取证书详情
 */
public class CertificateHolder {
    public static OERCertificate build(byte[] data) throws Exception {
        Certificate certificate = Certificate.getInstance(data);
        OERCertificate oerCertificate = new OERCertificate();
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x80) {
            byte[] bytes = GMSSLSM3DigestUtils.digestByBC(certificate.getEncode());
            byte[] goal = new byte[8];
            System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
            signerHashId8 = ByteArrayUtils.hexEncode(goal);
            oerCertificate.setIssueIdType(IssueIdType.NULL);
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = ByteArrayUtils.hexEncode(hashedId8.getString());
            oerCertificate.setIssueIdType(IssueIdType.CERTIFICATE_DIGEST);
            byte[] hashAlg = certificate.getIssuerId().getCertificateDigest().getHashAlgorithm().getEncode();
            BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlg, 0, 1);
            if (choice.intValue() == 0) {
                oerCertificate.setIssueIdAlg(CertHashType.SGD_SM3);
                new HashAlgorithm(HashAlgorithm.SGD_SM3);
            } else if (choice.intValue() == 1) {
                oerCertificate.setIssueIdAlg(CertHashType.SHA_256);
            } else {
                throw new Exception("不支持的类型");
            }
        }
        byte[] bytes = GMSSLSM3DigestUtils.digestByBC(certificate.getEncode());
        byte[] goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        String selfHashId8 = ByteArrayUtils.hexEncode(goal);
        byte[] r = certificate.getSignature().getR().getxOnly().getString();
        byte[] s = certificate.getSignature().getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        oerCertificate.setSelfHashId10(Hex.toHexString(ByteArrayUtils.getHashId10(data)));
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignerHashId8(signerHashId8);
        oerCertificate.setSelfHashId8(selfHashId8);
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setSignature(signature);
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionType.CIRCULAR_REGION.id) {
            oerCertificate.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.RECTANGULAR_REGION.id) {
            oerCertificate.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.POLYGONAL_REGION.id) {
            oerCertificate.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        oerCertificate.setItsAid(tbsCert.getItsAid());
        oerCertificate.setItsAidSspList(tbsCert.getItsAidSspList());
        oerCertificate.setRegionType(tbsCert.getRegionType());
        oerCertificate.setStartDate(tbsCert.getStartDate());
        oerCertificate.setEndDate(tbsCert.getEndDate());
        return oerCertificate;
    }
}
