package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.*;

import java.security.PrivateKey;
import java.util.List;

/***
 * ECA 调用解析 证书申请结构体
 */
public class AuthorizationValidationRequestEncHolder {

    private PrivateKey ecaPrivateKey;
    private AuthorizationValidationRequestEnc enc;
    private AuthorizationValidationRequestSign sign;

    private Certificate obuECert;

    /**
     * PCA -> ECA 证书申请 消息体解析
     * @param encEncoding PCA 证书私钥
     * @return PCA -> ECA 证书申请 消息体
     * @throws Exception 解析异常
     */
    public static AuthorizationValidationRequestEnc parseBytes(byte[] encEncoding) throws Exception {
        return AuthorizationValidationRequestEnc.getInstance(encEncoding);
    }

    public AuthorizationValidationRequestEncHolder(byte[] encEncoding, PrivateKey ecaPrivateKey) throws Exception {
        this(parseBytes(encEncoding), ecaPrivateKey);
    }

    public AuthorizationValidationRequestEncHolder(AuthorizationValidationRequestEnc enc, PrivateKey ecaPrivateKey) throws Exception {
        this.enc = enc;
        this.ecaPrivateKey = ecaPrivateKey;
        Payload payload = this.enc.getPayload();
        EncryptedData encData = payload.getEncData();
        SequenceOfRecipientInfo recipients = encData.getRecipients();
        List<RecipientInfo> recipientInfos = recipients.getRecipientInfos();
        for (RecipientInfo recipientInfo: recipientInfos) {
            PKRecipientInfo certRecipInfo = recipientInfo.getCertRecipInfo();
            EciesEncryptedKey kek = certRecipInfo.getKek();
            byte[] plain = KekResolveUtils.getPlain(kek, ecaPrivateKey);
            this.sign = AuthorizationValidationRequestSign.getInstance(plain);
        }
        throw new Exception("can`t decode enc data");
    }

    public int getVersion()
    {
        return this.enc.getVersion();
    }

    public AuthorizationValidationRequestEnc getEnc(){
        return this.enc;
    }

    public AuthorizationValidationRequestSign getSign() throws Exception {
        return this.sign;
    }

}