package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ASN1SM2Cipher;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.PrivateKey;

/**
 * @ClassName KekResolveUtils
 */
public class KekResolveUtils {
    private static Logger logger = LoggerFactory.getLogger(KekResolveUtils.class);

    public static byte[] getPlain(EciesEncryptedKey kek, PrivateKey privateKey) throws Exception {
        EccPoint v = kek.getV();
        OctetString x = v.getUncompressed().getX();
        byte[] datass = new byte[32 + 32 + 32 + 16];
        System.arraycopy(x.getString(), 0, datass, 0, x.getString().length);
        OctetString y = v.getUncompressed().getY();
        System.arraycopy(y.getString(), 0, datass, 32, y.getString().length);
        System.arraycopy(kek.getT().getString(), 0, datass, 32 + 32, kek.getT().getString().length);
        System.arraycopy(kek.getC().getString(), 0, datass, 32 + 32 + 32, kek.getC().getString().length);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(x.getString(), y.getString(), kek.getT().getString(), kek.getC().getString());
        if (privateKey instanceof SdfPrivateKey) {
            try {
                return GMSSLByteArrayUtils.base64Decode(GMSSLSM2EncryptUtils.decryptASN1ByYunhsm(((SdfPrivateKey) privateKey).getIndex(),
                        new String(((SdfPrivateKey) privateKey).getPassword()),
                        GMSSLByteArrayUtils.base64Encode(asn1SM2Cipher.getEncoded())));
            } catch (SdfSDKException e) {
                logger.error("解密失败", e);
                throw new Exception(e.getMessage());
            }
        }else {
            return BCUtils.sm2DecryptASN1ByBC(privateKey, asn1SM2Cipher.getEncoded());
        }
        //   return BCUtils.sm2DecryptASN1ByBC(privateKey, asn1SM2Cipher.getEncoded());
    }
}
