package com.xdja.pki.itsca.oer.app.data;



import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;


/**
 * EnrollmentCertRespData ::= SecureMessage(WITH COMPONENTS { ...,
 * version(2),
 * payload(WITH COMPONENTS { ...,
 * encData(WITH COMPONENTS { ...,
 * recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 * RecipientInfo(WITH COMPONENTS {
 * signedDataRecipInfo
 * })
 * }))
 * CA在颁发证书后，使用注册证书请求中的
 * EnrollmentCertRequestData->payload->signedData->tbs->data(CertRequest)->encryptionKey
 * 对颁发的证书进行随机加密计算，
 * 根据证书请求EnrollmentCertRequestData->payload->signedData->tbs->data(CertRequest)
 * 中的CertRequest数据的OER编码做HashID8计算并对
 * EnrollmentCertRespData->payload->encData->recipients->signedDataRecipInfo->recipientId赋值，
 * 终端在做EnrollmentCertResp数据验签后，获取其EnrollmentCertRespData数据并对其中的
 * EnrollmentCertRespData->payload->encData->cipherText解密，获取最终的注册证书数据。
 */
public class EnrollmentCertRespData extends CertDataBuilder {

    /**
     * @param certRequest 证书请求
     * @param key         对称密钥 16位
     * @return NormalCertRespData   F.3.2　非注册证书应答数据格式
     */
    public SecuredMessage build(CertRequest certRequest, byte[] key, byte[] data) throws Exception {
        return super.buildSecuredMessage(certRequest,true, key, data);
    }


}
