package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.SequenceOf;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/***
 *
 * SequenceOfRevokeInfo ::= SEQUENCE OF RevokeInfo
 *
 */

public class SequenceOfRevokeInfo extends SequenceOf {
    private static Logger logger = LoggerFactory.getLogger(SequenceOfRevokeInfo.class);

    public void addRevokeInfo(RevokeInfo revokeInfo) {
        super.addOERObject(revokeInfo);
    }

    private List<RevokeInfo> revokeInfos = new ArrayList<>();

    public List<RevokeInfo> getRevokeInfos() {
        return revokeInfos;
    }

    public void setRevokeInfo(RevokeInfo revokeInfo) {
        this.revokeInfos.add(revokeInfo);
    }

    public static SequenceOfRevokeInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SequenceOfRecipientInfo  start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfRevokeInfo sequenceOfRevokeInfo = new SequenceOfRevokeInfo();
        for (int i = 0; i < length.intValue(); i++) {
            RevokeInfo instance = RevokeInfo.getInstance(goal);
            goal = instance.getGoal();
            sequenceOfRevokeInfo.addRevokeInfo(instance);
            sequenceOfRevokeInfo.setRevokeInfo(instance);
            ByteArrayUtils.printHexBinary(logger, "SequenceOfRevokeInfo  at index" + i + "RevokeInfo data ", instance.getEncode());
        }
        sequenceOfRevokeInfo.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "SequenceOfRevokeInfo lave data ", goal);
        return sequenceOfRevokeInfo;
    }
}
