package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 * -- 6.2.2.4 主题信息
 *
 * SubjectInfo ::= SEQUENCE {
 *     subjectType SubjectType,
 *     subjectName OCTET STRING(SIZE(0..32))
 * }
 */
public class SubjectInfo extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SubjectInfo.class);
    private SubjectType subjectType;
    private OctetString subjectName;

    public SubjectInfo() {
        super(false, false);
    }

    public static SubjectInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SubjectInfo start data", data);
        SubjectInfo subjectInfo = new SubjectInfo();
        SubjectType subjectType = SubjectType.getInstance(data);
        data = subjectType.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SubjectInfo SubjectType data", subjectType.getEncode());
        OctetString octetString = OctetString.getInstance(data);
        OctetString subjectName = new OctetString();
        subjectName.setString(octetString.getString());
        subjectName.setGoal(octetString.getGoal());
        data = subjectName.getGoal();
        ByteArrayUtils.printHexBinary(logger, "SubjectInfo subjectName data", subjectName.getEncode());
        subjectInfo.setSubjectName(subjectName);
        subjectInfo.setSubjectType(subjectType);
        subjectInfo.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "SubjectInfo lave data", subjectInfo.getGoal());
        return subjectInfo;
    }

    public SubjectType getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public OctetString getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(OctetString subjectName) {
        this.subjectName = subjectName;
    }

    public void setSubjectName(byte[] subjectName) {
        this.subjectName = new OctetString();
        this.subjectName.setString(subjectName);
    }

//    public SubjectInfo(SubjectType subjectType, byte[] subjectName) throws IOException {
//        super(false);
////        SubjectType subjectType = new SubjectType();
////        subjectType.addValue(SubjectType.AUTHORIZATION_TICKET);
//        this.write(subjectType.getEncode());
//        ByteArrayUtils.printHexBinary(logger, "subjectType", subjectType.getEncode());
//        OctetString snos = new OctetString(subjectName);
//        ByteArrayUtils.printHexBinary(logger, "subjectName", snos.getEncode());
//        logger.info("subjectName string {}", new String(subjectName));
//        this.write(snos.getEncode());
//    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(subjectType);
        vector.add(subjectName);
        return vector;
    }
}
