package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;


/***
 * SymmetricAlgorithm ::= ENUMERATED {
 *     sgdsm4ecb,
 *     sgdsm4cbc,
 *     sgdsm4cfb,
 *     sgdsm4efb,
 *     sgdsm4ofb,
 *     aes128ccm,
 *     ...
 * }
 */
public class SymmetricAlgorithm extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(SymmetricAlgorithm.class);
    public static final Value SGD_SM4_ECB = new Value(0, "SGD_SM4_ECB");
    public static final Value SGD_SM4_CBC = new Value(1, "SGD_SM4_CBC");
    public static final Value SGD_SM4_CFB = new Value(2, "SGD_SM4_CFB");
    public static final Value SGD_SM4_EFB = new Value(3, "SGD_SM4_EFB");
    public static final Value SGD_SM4_OFB = new Value(4, "SGD_SM4_OFB");
    public static final Value AES_128_CCM = new Value(5, "AES_128_CCM");

    public static SymmetricAlgorithm getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SymmetricAlgorithm start data", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        SymmetricAlgorithm symmetricAlgorithm;
        if (choice.intValue() == 0) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_ECB");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB);
        } else if (choice.intValue() == 1) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_CBC");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_CBC);
        } else if (choice.intValue() == 2) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_CFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_CFB);
        } else if (choice.intValue() == 3) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_EFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_EFB);
        } else if (choice.intValue() == 4) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_OFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_OFB);
        } else if (choice.intValue() == 5) {
            logger.debug("SymmetricAlgorithm choice AES_128_CCM");
            symmetricAlgorithm = new SymmetricAlgorithm(SymmetricAlgorithm.AES_128_CCM);
        } else {
            logger.error("SymmetricAlgorithm choice is error " + choice.intValue());
            throw new Exception("不支持的类型");
        }
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        symmetricAlgorithm.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "SymmetricAlgorithm lave data", symmetricAlgorithm.getGoal());
        return symmetricAlgorithm;
    }

    public SymmetricAlgorithm(Value value) {
        super(value);
        this.addValueToList(SGD_SM4_ECB);
        this.addValueToList(SGD_SM4_CBC);
        this.addValueToList(SGD_SM4_CFB);
        this.addValueToList(SGD_SM4_EFB);
        this.addValueToList(SGD_SM4_OFB);
        this.addValueToList(AES_128_CCM);
    }

    public Value readValue() throws IOException {
        return this.readValue();
    }
}
