package com.xdja.pki.itsca.oer.asn1.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;

/**
 * Uint16 ::= INTEGER (0..65535)
 * 如果下界是不小于0和上限不大于65535，并且约束是不可扩展的，整数值被编码为 无符号 在二进制整数 两个八位位组;
 * <p>
 * uintN_t	bits	bytes	对应Java实现
 * uint8_t	8	    1	    short
 * uint16_t	16	    2	    int
 * uint32_t	32	    4	    long
 */
public class Uint16 extends OERObject {

    private byte[] bytes;

    public Uint16(int i) throws IOException {
        if (i <= 65535 && i >= 0) {
            this.bytes = ByteBuffer.allocate(Short.BYTES).putShort((short) i).array();
        } else {
            throw new IOException("Uint16 must in 0-65535");
        }
    }

    private Uint16() {

    }

    public static Uint16 getInstance(byte[] obj) {
        Uint16 uint16 = new Uint16();
        uint16.fromByteArray(obj);
        return uint16;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        vector.add(bytes);
        return vector;
    }
}