package com.xdja.pki.itsca.oer.asn1.base;

import java.io.IOException;
import java.util.Vector;

/**
 * Uint3 ::= INTEGER (0..7)
 * 如果下界值范围约束的是不小于0和上限不大于7并且约束是不可扩展的，整数值被编码为 无符号 在二进制整数 一个八位字节;
 *
 * uintN_t	bits	bytes	对应Java实现
 * uint8_t	8	    1	    short
 * uint16_t	16	    2	    int
 * uint32_t	32	    4	    long
 */
public class Uint3 extends OERObject {

    private int i;

    public Uint3(int i) throws IOException {
        this((short) i);
    }

    public Uint3(short i) throws IOException {
        if (i <= 7 && i >= 0){
            this.i = i;
        } else {
            throw new IOException("Uint3 must in 0-7");
        }
    }

    private Uint3() {

    }

    public static Uint3 getInstance(byte[] obj) {
        Uint3 uint3 = new Uint3();
        uint3.fromByteArray(obj);
        return uint3;
    }


    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        vector.add(i);
        return vector;
    }
}
