package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Vector;

/**
 * Uint32 ::= INTEGER (0..4294967295)
 * 如果下界是不小于0和上限不大于4294967295，并且约束是不可扩展的，整数值被编码为 无符号 在二进制整数 四个八位组;
 *
 * uintN_t	bits	bytes	对应Java实现
 * uint8_t	8	    1	    short
 * uint16_t	16	    2	    int
 * uint32_t	32	    4	    long
 */
public class Uint32 extends OERObject {
    private static Logger logger = LoggerFactory.getLogger(Uint32.class);
    private byte[] bytes;

    public Uint32(long i) throws IOException {
        if (i <= 4294967295L && i >= 0){
            bytes = ByteBuffer.allocate(Integer.BYTES).putInt((int)i).array();
        } else {
            throw new IOException("Uint32 must in 0-4294967295L");
        }
    }
    private Uint32() {

    }

    public static Uint32 getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "lave data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 4);
        Uint32 uint32 = new Uint32(integer.longValue());
        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        uint32.setGoal(goal);
        return uint32;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector vector = new Vector();
        vector.add(bytes);
        return vector;
    }
}