package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.Uint32;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import org.bouncycastle.crypto.CryptoException;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.List;

public class CRLBuilder {

    public CRL build(PrivateKey privateKey, int serial, byte[] issuedHash, List<byte[]> hashedId10s) throws Exception {
        EccCurve eccCurve = new EccCurve(EccCurve.SGD_SM2);

        CRL crl = new CRL();

        IssuerId issuerId = new IssuerId();
        CertificateDigest certificateDigest = new CertificateDigest();
        HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certificateDigest.setHashAlgorithm(hashAlgorithm);
        HashedId8 hashedId8 = new HashedId8(issuedHash);
        certificateDigest.setHashedId8(hashedId8);
        issuerId.setCertificateDigest(certificateDigest);
        crl.setIssuerId(issuerId);

        ToBeSignedCrl toBeSignedCrl = new ToBeSignedCrl();
        Uint32 crlSerial = new Uint32(serial);
        long nowTime = TimeUtils.getNowTime();
        Time32 issueDate = new Time32(nowTime);
        long nextTime = TimeUtils.getTimeAfterYear(1);
        Time32 nextCrl = new Time32(nextTime);
        SequenceOfRevokeInfo sequenceOfRevokeInfo = new SequenceOfRevokeInfo();
        for (byte[] hashedId10 : hashedId10s) {
            RevokeInfo revokeInfo = new RevokeInfo();
            HashAlgorithm rh = new HashAlgorithm(HashAlgorithm.SGD_SM3);
            HashedId10 id = new HashedId10(hashedId10);
            revokeInfo.setHashAlgorithm(rh);
            revokeInfo.setHashedId10(id);
            sequenceOfRevokeInfo.addRevokeInfo(revokeInfo);
        }
        toBeSignedCrl.setCrlSerial(crlSerial);
        toBeSignedCrl.setIssueDate(issueDate);
        toBeSignedCrl.setNextCrl(nextCrl);
        toBeSignedCrl.setEntries(sequenceOfRevokeInfo);
        crl.setToBeSignedCrl(toBeSignedCrl);

        byte[] r;
        byte[] s;
        try {
            byte[] sign;
            if (privateKey instanceof SdfPrivateKey){
                sign = GMSSLSM2SignUtils.signBySdfWithUserId(SdfCryptoType.YUNHSM,
                        ((SdfPrivateKey) privateKey).getIndex(),
                        new String(((SdfPrivateKey) privateKey).getPassword()),
                        "China".getBytes(),toBeSignedCrl.getEncode());
            }else {
                sign = BCUtils.sm2SignByBC(privateKey, toBeSignedCrl.getEncode());
            }
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert derDecode != null && derDecode.length == 2;
            r = derDecode[0];
            s = derDecode[1];
        } catch (Exception e) {
            throw new Exception(e);
        }
        Signature signature = new Signature();
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        signature.setS(s);
        crl.setSignature(signature);

        return crl;
    }
}
