package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.CRL;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.RevokeInfo;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRevokeInfo;
import com.xdja.pki.itsca.oer.cert.bean.OERCRL;
import com.xdja.pki.itsca.oer.cert.bean.OERRevokeInfo;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import org.bouncycastle.util.BigIntegers;

import java.util.ArrayList;
import java.util.List;


public class CRLHolder {
    public static OERCRL build(byte[] data) throws Exception {
        CRL crl = CRL.getInstance(data);
        OERCRL oercrl = new OERCRL();
        try {
            HashedId8 hashedId8 = crl.getIssuerId().getCertificateDigest().getHashedId8();
            oercrl.setSignerHashId8(ByteArrayUtils.hexEncode(hashedId8.getString()));
        } catch (Exception e) {
            //
        }
//        byte[] bytes = BCUtils.sm3DigestByBC(data);
        byte[] bytes = GMSSLSM3DigestUtils.digestByBC(data);
        byte[] goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        oercrl.setSelfHashId8(ByteArrayUtils.hexEncode(goal));

        SequenceOfRevokeInfo entries = crl.getToBeSignedCrl().getEntries();
        List<OERRevokeInfo> infos = new ArrayList<>();
        for (RevokeInfo revokeInfo : entries.getRevokeInfos()) {
            OERRevokeInfo build = RevokeInfoHolder.build(revokeInfo.getEncode());
            infos.add(build);
        }
        oercrl.setList(infos);
        long issueDate = BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getIssueDate().getEncode()).longValue();
        long nextDate = BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getNextCrl().getEncode()).longValue();
        oercrl.setIssueDate(TimeUtils.getTime(issueDate));
        oercrl.setNextDate(TimeUtils.getTime(nextDate));
        oercrl.setCrlSerial(BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getCrlSerial().getEncode()).longValue());
        return oercrl;
    }
}
