package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.cert.bean.GeographicRegionType;
import com.xdja.pki.itsca.oer.cert.bean.OERCertRequest;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.utils.X509Utils;

import java.security.PublicKey;

/**
 * @ClassName CertRequestHolder
 */
public class CertRequestHolder {
    public static OERCertRequest build(byte[] data) throws Exception {
        CertRequest instance = CertRequest.getInstance(data);
        TbsCert tbsCertData = instance.getTbsCertData();
        OERTbsCert tbsCert = TbsCertHolder.build(tbsCertData.getEncode());
        OERCertRequest certRequest = new OERCertRequest();
        try {
            PublicEncryptionKey encryptionKey = instance.getEncryptionKey();
            Uncompressed uncompressed = encryptionKey.getPublicKey().getUncompressed();
            byte[] x = uncompressed.getX().getString();
            byte[] y = uncompressed.getY().getString();
            PublicKey publicKey = X509Utils.convertSM2PublicKey(x, y);
            certRequest.setSnapPublic(publicKey);
        } catch (Exception e) {
            //
        }

        certRequest.setStartTime(tbsCert.getStartTime());
        certRequest.setEndTime(tbsCert.getEndTime());
        certRequest.setSubjectName(tbsCert.getSubjectName());
        certRequest.setSubjectType(tbsCert.getSubjectType());
        certRequest.setSignPublicKey(tbsCert.getSignPublicKey());
        certRequest.setEncPublicKey(tbsCert.getEncPublic());
        certRequest.setItsAid(tbsCert.getItsAid());
        certRequest.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionType.CIRCULAR_REGION.id) {
            certRequest.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.RECTANGULAR_REGION.id) {
            certRequest.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionType.POLYGONAL_REGION.id) {
            certRequest.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        certRequest.setItsAid(tbsCert.getItsAid());
        certRequest.setItsAidSspList(tbsCert.getItsAidSspList());
        certRequest.setRegionType(tbsCert.getRegionType());
        certRequest.setStartDate(tbsCert.getStartDate());
        certRequest.setEndDate(tbsCert.getEndDate());
        return certRequest;
    }
}
