package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.RevokeInfo;
import com.xdja.pki.itsca.oer.cert.bean.OERRevokeInfo;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;

/**
 * @ClassName RevokeInfoHolder
 */
public class RevokeInfoHolder {
    public static OERRevokeInfo build(byte[] data) throws Exception {
        RevokeInfo revokeInfo = RevokeInfo.getInstance(data);
        OERRevokeInfo info = new OERRevokeInfo();
        HashAlgorithm hashAlg = revokeInfo.getHashAlgorithm();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlg.getEncode(), 0, 1);
        if (choice.intValue() == 0) {
            info.setHashAlgorithm("SGD_SM3");
        } else {
            info.setHashAlgorithm("SHA_256");
        }
        String certId = Hex.toHexString(revokeInfo.getHashedId10().getString());
        info.setIssueHashId10(certId);
        if (null != revokeInfo.getExpiry()) {
            String time = TimeUtils.getTime(BigIntegers.fromUnsignedByteArray(revokeInfo.getExpiry().getEncode()).longValue());
            info.setExpiry(time);

        }
      return info;
    }
}
