package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.cert.bean.OERCertificate;
import com.xdja.pki.itsca.oer.cert.bean.OERSignedData;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.List;

/**
 * @ClassName SignedDataHolder
 */
public class SignedDataHolder {
    public static OERSignedData build(byte[] data) throws Exception {
        SignedData signedData = SignedData.getInstance(data);
        SignerInfo signerInfo = signedData.getSignerInfo();
        OERSignedData oerSignedData = new OERSignedData();
        byte[] encode = signerInfo.getEncode();
        if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x81) {
            List<Certificate> certificates = signerInfo.getCertificate().getCertificates();
            for (int i = 0; i < certificates.size(); i++) {
                OERCertificate certificate = CertificateHolder.build(certificates.get(i).getEncode());
                System.out.println(certificate);
                oerSignedData.setCertificate(certificate);
            }
        } else if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x82) {
            HashedId8 hashedId8 = signerInfo.getCertificateDigest().getHashedId8();
            oerSignedData.setSignerHashId8(ByteArrayUtils.hexEncode(hashedId8.getString()));
        } else {
            byte[] bytes = GMSSLSM3DigestUtils.digestByBC(signedData.getTbs().getEncode());
            byte[] goal = new byte[8];
            System.arraycopy(bytes, data.length - 8, goal, 0, goal.length);
            oerSignedData.setSignerHashId8(ByteArrayUtils.hexEncode(goal));
        }

        TBSData tbsData = signedData.getTbs();
        oerSignedData.setData(tbsData.getData().getEncode());

        Int itsAid = tbsData.getHeaderInfo().getItsAid();
        int value = itsAid.getValue();
        oerSignedData.setItsAid(value);

        HashAlgorithm hashAlg = tbsData.getHeaderInfo().getHashAlg();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlg.getEncode(), 0, 1);
        if (choice.intValue() == 0) {
            oerSignedData.setHashAlg("SGD_SM3");
        } else {
            oerSignedData.setHashAlg("SHA_256");
        }
        Signature sign = signedData.getSign();
        byte[] r = sign.getR().getxOnly().getString();
        byte[] s = sign.getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        oerSignedData.setSignature(signature);
        return oerSignedData;
    }

}
