package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.bean.SM4CipherType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;

/***
 * PCA 调用 生成 证书申请结构体
 */
public class AuthorizationValidationRequestEncBuilder {

    /**
     * PCA -> ECA 证书申请 请求 消息体生成
     *
     * @param pcaPrivateKey   PCA 证书私钥
     * @param pcaCertificate  PCA 证书
     * @param ecaCertificate  ECA 证书
     * @param sharedATRequest OBU -> PCA 请求中的 sharedATRequest
     * @param ecSignature     OBU -> PCA 请求中的 ecSignature
     * @return PCA -> ECA 证书申请 请求 消息体
     * @throws Exception 生成异常
     */
    public static SecuredMessage builder(
            PrivateKey pcaPrivateKey,
            Certificate pcaCertificate,
            Certificate ecaCertificate,
            SharedATRequest sharedATRequest,
            EcSignature ecSignature
    ) throws Exception {
        AuthorizationValidationRequest request = new AuthorizationValidationRequest(sharedATRequest, ecSignature);
        SecuredMessage sign = SecuredMessageBuilder.buildSignedDataSecuredMessage(
                ItsAidInt.NON_REGISTRATION_CERTIFICATE_REQUEST,
                pcaPrivateKey,
                pcaCertificate,
                request.getEncode()
        );
        ByteArrayUtils.printHexBinary(null, "sign", sign.getEncode());
        SecuredMessage securedMessage = SecuredMessageBuilder.buildEncryptedDataSecuredMessage(ecaCertificate, sign.getEncode());
        ByteArrayUtils.printHexBinary(null, "securedMessage", securedMessage.getEncode());
        return securedMessage;
    }

}