package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Vector;

/***
 * CertificateDigest ::= SEQUENCE {
 *     algorithm HashAlgorithm,
 *     digest HashedId8
 * }
 */
public class CertificateDigest extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(CertificateDigest.class);
    private HashAlgorithm hashAlgorithm;
    private HashedId8 hashedId8;

    public CertificateDigest() {
        super(false, false);
    }

    public static CertificateDigest getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "CertificateDigest start data", data);
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        data = hashAlgorithm.getGoal();
        ByteArrayUtils.printHexBinary(logger, "CertificateDigest hashAlgorithm data", hashAlgorithm.getEncode());
        byte[] goal = new byte[8];
        System.arraycopy(data, 0, goal, 0, goal.length);
        HashedId8 hashedId8 = new HashedId8(goal);
        goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        data = goal;
        ByteArrayUtils.printHexBinary(logger, "CertificateDigest hashedId8 data", hashedId8.getEncode());
        CertificateDigest certificateDigest = new CertificateDigest();
        certificateDigest.setHashedId8(hashedId8);
        certificateDigest.setHashAlgorithm(hashAlgorithm);
        certificateDigest.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "CertificateDigest lave data", data);
        return certificateDigest;
    }


    public HashAlgorithm getHashAlgorithm() {
        return hashAlgorithm;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public HashedId8 getHashedId8() {
        return hashedId8;
    }

    public void setHashedId8(HashedId8 hashedId8) {
        this.hashedId8 = hashedId8;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(hashAlgorithm);
        vector.add(hashedId8);
        return vector;
    }
}
