package com.xdja.pki.itsca.oer.asn1;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;

/***
 * -- 6.2.2.6 有效性限定
 *
 * GeographicRegion ::= CHOICE {
 *     circularRegion     CircularRegion,
 *     rectangularRegion  SequenceOfRectangularRegion,
 *     polygonalRegion    PolygonalRegion,
 *     ...
 * }
 *
 */
public class GeographicRegion extends Choice {

    private static Logger logger = LoggerFactory.getLogger(GeographicRegion.class);
    private CircularRegion circularRegion;
    private SequenceOfRectangularRegion rectangularRegion;
    private PolygonalRegion polygonalRegion;

    public CircularRegion getCircularRegion() {
        return circularRegion;
    }

    public static GeographicRegion getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "GeographicRegion start data", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        GeographicRegion geographicRegion = new GeographicRegion();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (choice.intValue() - 0x80 == 0) {
            logger.debug("GeographicRegion choice circularRegion");
            CircularRegion circularRegion = CircularRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion circularRegion data", circularRegion.getEncode());
            geographicRegion.setCircularRegion(circularRegion);
            data = circularRegion.getGoal();
        } else if (choice.intValue() - 0x80 == 1) {
            logger.debug("GeographicRegion choice rectangularRegion");
            SequenceOfRectangularRegion instance = SequenceOfRectangularRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion rectangularRegion data", instance.getEncode());
            geographicRegion.setRectangularRegion(instance);
            data = instance.getGoal();
        } else if (choice.intValue() - 0x80 == 2) {
            logger.debug("GeographicRegion choice polygonalRegion");
            PolygonalRegion polygonalRegion = PolygonalRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion polygonalRegion data", polygonalRegion.getEncode());
            geographicRegion.setPolygonalRegion(polygonalRegion);
            data = polygonalRegion.getGoal();
        } else {
            logger.error("GeographicRegion choice is error" + choice.intValue());
            throw new Exception("不支持的类型");
        }
        geographicRegion.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "GeographicRegion lave data", data);
        return geographicRegion;
    }

    public void setCircularRegion(CircularRegion circularRegion) {
        this.circularRegion = circularRegion;
    }

    public SequenceOfRectangularRegion getRectangularRegion() {
        return rectangularRegion;
    }

    public void setRectangularRegion(SequenceOfRectangularRegion rectangularRegion) {
        this.addIndex(1);
        this.rectangularRegion = rectangularRegion;
    }

    public PolygonalRegion getPolygonalRegion() {
        return polygonalRegion;
    }

    public void setPolygonalRegion(PolygonalRegion polygonalRegion) {
        this.addIndex(2);
        this.polygonalRegion = polygonalRegion;
    }

    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        vector.add(circularRegion);
        vector.add(rectangularRegion);
        vector.add(polygonalRegion);
        return vector;
    }

}
