package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/**
 * -- 6.3.2.3 签名消息头
 * --  itsAid: 智能交通应用标识
 * --  hashAlg：digest和extHash所使用的摘要算法，缺省为SM3
 * --  genTime  消息产生时间
 * --  expiryTime  消息的失效时间
 * --  location    消息产生的地理坐标
 * --  digest      用于SDS获取仅有标识、但没有完整内容的证书
 * --  encKey      标识响应数据需要使用encKey制定的对称加密算法加密，且用指定的公钥对对称密钥加密
 * HeaderInfo ::= SEQUENCE{
 * itsAid  INTEGER,
 * hashAlg     HashAlgorithm   Optional,
 * genTime     Time64          Optional,
 * expiryTime  Time64          Optional,
 * location    ThreeDLocation  Optional,
 * digest      HashedId3       Optional,
 * encKey      PublicEncryptionKey Optional
 * }
 */
public class HeaderInfo extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(HeaderInfo.class);
    private Int itsAid;
    private HashAlgorithm hashAlg;
    private Time64 genTime;
    private Time64 expiryTime;
    private ThreeDLocation location;
    private HashedId3 digest;
    private PublicEncryptionKey encKey;

    public HeaderInfo() {
        super(false, true);
    }

    public static HeaderInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "HeaderInfo start data ", data);
        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        HeaderInfo headerInfo = new HeaderInfo();
        List<Integer> integers = BitByte.setBit(bigInteger.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        Int itsAid = Int.getInstance(data);
        headerInfo.setItsAid(itsAid);
        ByteArrayUtils.printHexBinary(logger, "HeaderInfo itsAid data ", itsAid.getEncode());
        data = itsAid.getGoal();
        //HashAlgorithm
        if (integers.contains(0)) {
            HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
            headerInfo.setHashAlg(hashAlgorithm);
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo HashAlgorithm data ", hashAlgorithm.getEncode());
            data = hashAlgorithm.getGoal();
//            bigInteger = BigIntegers.fromUnsignedByteArray(data, 0, 1);
//            if (bigInteger.intValue() == 0) {
//                headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
//            } else if (bigInteger.intValue() == 1) {
//                headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SHA_256));
//            } else {
//                throw new Exception("转化HashAlgorithm失败 " + bigInteger.intValue());
//            }
//            goal = new byte[data.length - 1];
//            System.arraycopy(data, 1, goal, 0, goal.length);
//            data = goal;
        }
        //genTime
        if (integers.contains(1)) {
            bigInteger = BigIntegers.fromUnsignedByteArray(data, 0, 8);
            Time64 genTime = new Time64(bigInteger.longValue());
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo genTime data ", genTime.getEncode());
            headerInfo.setGenTime(genTime);
            goal = new byte[data.length - 8];
            System.arraycopy(data, 8, goal, 0, goal.length);
            data = goal;
        }
        //expiryTime
        if (integers.contains(2)) {
            bigInteger = BigIntegers.fromUnsignedByteArray(data, 0, 8);
            Time64 expiryTime = new Time64(bigInteger.longValue());
            headerInfo.setExpiryTime(expiryTime);
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo expiryTime data ", expiryTime.getEncode());
            goal = new byte[data.length - 8];
            System.arraycopy(data, 8, goal, 0, goal.length);
            data = goal;
        }
        //location
        if (integers.contains(3)) {
            ByteArrayUtils.printHexBinary(logger, " data ", data);
            ThreeDLocation threeDLocation = ThreeDLocation.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo threeDLocation data ", threeDLocation.getEncode());
            headerInfo.setLocation(threeDLocation);
            data = threeDLocation.getGoal();
        }
        //digest
        if (integers.contains(4)) {
            goal = new byte[3];
            System.arraycopy(data, 0, goal, 0, goal.length);
            HashedId3 hashedId3 = new HashedId3(goal);
            goal = new byte[data.length - 3];
            System.arraycopy(data, 3, goal, 0, goal.length);
            data = goal;
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo HashedId3 data ", hashedId3.getEncode());
            headerInfo.setDigest(hashedId3);
        }
        //encKey
        if (integers.contains(5)) {
            ByteArrayUtils.printHexBinary(logger, " data ", data);
            PublicEncryptionKey publicEncryptionKey = PublicEncryptionKey.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "HeaderInfo publicEncryptionKey data ", publicEncryptionKey.getEncode());
            headerInfo.setEncKey(publicEncryptionKey);
            data = publicEncryptionKey.getGoal();
        }
        headerInfo.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "HeaderInfo lave data ", data);
        return headerInfo;
    }

    public Int getItsAid() {
        return itsAid;
    }

    public void setItsAid(Int itsAid) {
        this.itsAid = itsAid;
    }

    public HashAlgorithm getHashAlg() {
        return hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public Time64 getGenTime() {
        return genTime;
    }

    public void setGenTime(Time64 genTime) {
        this.genTime = genTime;
    }

    public Time64 getExpiryTime() {
        return expiryTime;
    }

    public void setExpiryTime(Time64 expiryTime) {
        this.expiryTime = expiryTime;
    }

    public ThreeDLocation getLocation() {
        return location;
    }

    public void setLocation(ThreeDLocation location) {
        this.location = location;
    }

    public HashedId3 getDigest() {
        return digest;
    }

    public void setDigest(HashedId3 digest) {
        this.digest = digest;
    }

    public PublicEncryptionKey getEncKey() {
        return encKey;
    }

    public void setEncKey(PublicEncryptionKey encKey) {
        this.encKey = encKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (null != this.hashAlg) {
            optionals.add(7);
        }
        if (null != this.genTime) {
            optionals.add(6);
        }
        if (null != this.expiryTime) {
            optionals.add(5);
        }
        if (null != this.location) {
            optionals.add(4);
        }
        if (null != this.digest) {
            optionals.add(3);
        }
        if (null != this.encKey) {
            optionals.add(2);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(itsAid);
        vector.add(hashAlg);
        vector.add(genTime);
        vector.add(expiryTime);
        vector.add(location);
        vector.add(digest);
        vector.add(encKey);
        return vector;
    }

}
