package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/***
 *
 * RevokeInfo ::= SEQUENCE {
 *     id HashedId10, -- 被作废证书的 HashedId
 *     hashAlg HashAlgorithm,
 *     expiry Time32 OPTIONAL,
 *     ...
 * }
 *
 */
public class RevokeInfo extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(RevokeInfo.class);
    private HashAlgorithm hashAlgorithm;
    private HashedId10 hashedId10;
    private Time32 expiry;

    public RevokeInfo() {
        super(true, true);
    }

    public static RevokeInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo start data", data);
        RevokeInfo revokeInfo = new RevokeInfo();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(choice.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        data = hashAlgorithm.getGoal();
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo hashAlgorithm data", hashAlgorithm.getEncode());
        HashedId10 hashedId10 = HashedId10.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo hashedId10 data", hashedId10.getEncode());
        data = hashedId10.getGoal();
        //可扩展
        if (integers.contains(0)) {

        }
        //Time32 expiry;
        if (integers.contains(1)) {
            Time32 expiry = Time32.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "RevokeInfo expiry data", expiry.getEncode());
            revokeInfo.setExpiry(expiry);
            data = expiry.getGoal();
        }
        revokeInfo.setHashedId10(hashedId10);
        revokeInfo.setHashAlgorithm(hashAlgorithm);
        revokeInfo.setGoal(data);
        return revokeInfo;
    }

    public HashAlgorithm getHashAlgorithm() {
        return hashAlgorithm;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public HashedId10 getHashedId10() {
        return hashedId10;
    }

    public void setHashedId10(HashedId10 hashedId10) {
        this.hashedId10 = hashedId10;
    }

    public Time32 getExpiry() {
        return expiry;
    }

    public void setExpiry(Time32 expiry) {
        this.expiry = expiry;
    }

//    public RevokeInfo(byte[] hashId) throws IOException {
//        super(true);
//        HashedId10 id = new HashedId10(hashId);
//        HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
//        this.write(id);
//        this.write(hashAlgorithm);
//    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(hashAlgorithm);
        vector.add(hashedId10);
        if (expiry != null) {
            this.addOptional(Arrays.asList(7));
            vector.add(expiry);
        }
        return vector;
    }
}
