package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/**
 * --  data：随载荷发送的待签名的数据
 * --  extHash 如果待签名数据较大或对方已知，不随负载发送，则用外部待签数据的摘要表示
 * TBSData ::= SEQUENCE{
 * headerInfo  HeaderInfo,
 * data        OCTET STRING(SIZE(0..MAX))  Optional,
 * extHash     OCTET STRING(SIZE(32))  Optional,
 * }
 */
public class TBSData extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(TBSData.class);
    private HeaderInfo headerInfo;
    private OctetString data;
    private OctetString extHash;

    public TBSData() {
        super(false, true);
    }

    public static TBSData getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "TBSData start data ", data);
        TBSData tbsData = new TBSData();
        BigInteger optional = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        HeaderInfo headerInfo = HeaderInfo.getInstance(data);
        data = headerInfo.getGoal();
        tbsData.setHeaderInfo(headerInfo);
        ByteArrayUtils.printHexBinary(logger, "TBSData HeaderInfo  data ", headerInfo.getEncode());
        List<Integer> integers = BitByte.setBit(optional.intValue()).readIndexes();
        if (integers.contains(0)) {
            logger.debug("TBSData choice data");
            OctetString octetString = OctetString.getInstance(data);
            data = octetString.getGoal();
            ByteArrayUtils.printHexBinary(logger, "TBSData data  data ", octetString.getEncode());
            tbsData.setData(octetString);
        }
        if (integers.contains(1)) {
            logger.debug("TBSData choice extHash");
            OctetString extHash = new OctetString();
            extHash.setLength(32);
            goal = new byte[32];
            System.arraycopy(data, 0, goal, 0, goal.length);
            extHash.setString(goal);
            tbsData.setExtHash(extHash);
            ByteArrayUtils.printHexBinary(logger, "TBSData extHash  data ", extHash.getEncode());
            goal = new byte[data.length - 32];
            System.arraycopy(data, 32, goal, 0, goal.length);
            data = goal;
        }
        ByteArrayUtils.printHexBinary(logger, " TBSData end data", data);
        tbsData.setGoal(data);
        return tbsData;
    }

    public void setHeaderInfo(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
    }

    public void setData(OctetString data) {
        this.data = data;
    }

    public void setExtHash(OctetString extHash) {
        this.extHash = extHash;
    }

    public HeaderInfo getHeaderInfo() {
        return headerInfo;
    }

    public OctetString getData() {
        return data;
    }

    public OctetString getExtHash() {
        return extHash;
    }

    public void setData(byte[] data) {
        this.data = new OctetString();
        this.data.setString(data);
    }

    public void setExtHash(byte[] extHash) {
        this.extHash = new OctetString();
        this.extHash.setLength(32);
        this.extHash.setString(extHash);
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (null != this.data) {
            optionals.add(7);
        }
        if (null != this.extHash) {
            optionals.add(6);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(headerInfo);
        vector.add(data);
        vector.add(extHash);
        return vector;
    }
}
